/*
 * Decompiled with CFR 0.152.
 */
package org.talend.dataprep.api.dataset.statistics.number;

import java.util.List;
import org.apache.commons.lang.NotImplementedException;
import org.talend.daikon.number.BigDecimalParser;
import org.talend.dataprep.api.dataset.statistics.number.StreamNumberHistogramStatistics;
import org.talend.dataquality.common.inference.Analyzer;
import org.talend.dataquality.common.inference.ResizableList;
import org.talend.dataquality.statistics.numeric.NumericalStatisticsAnalyzer;
import org.talend.dataquality.statistics.type.DataTypeEnum;
import org.talend.dataquality.statistics.type.TypeInferenceUtils;

public class StreamNumberHistogramAnalyzer
extends NumericalStatisticsAnalyzer<StreamNumberHistogramStatistics> {
    private static final long serialVersionUID = -3756520692420812485L;
    private final ResizableList<StreamNumberHistogramStatistics> stats = new ResizableList(StreamNumberHistogramStatistics.class);

    public StreamNumberHistogramAnalyzer(DataTypeEnum[] types) {
        super(types);
    }

    public boolean analyze(String ... record) {
        DataTypeEnum[] types = this.getTypes();
        if (record.length != types.length) {
            throw new IllegalArgumentException("Each column of the record should be declared a DataType.Type corresponding! \n" + types.length + " type(s) declared in this histogram analyzer but " + record.length + " column(s) was found in this record. \n" + "Using method: setTypes(DataType.Type[] types) to set the types. ");
        }
        if (this.stats.resize(record.length)) {
            for (StreamNumberHistogramStatistics stat : this.stats) {
                stat.setNumberOfBins(32);
            }
        }
        Integer[] integerArray = this.getStatColIdx();
        int n = integerArray.length;
        for (int i = 0; i < n; ++i) {
            String value;
            int index = (Integer)integerArray[i];
            if (!TypeInferenceUtils.isValid((DataTypeEnum)types[index], (String)(value = record[index]))) continue;
            ((StreamNumberHistogramStatistics)this.stats.get(index)).add(BigDecimalParser.toBigDecimal((String)value).doubleValue());
        }
        return true;
    }

    public Analyzer<StreamNumberHistogramStatistics> merge(Analyzer<StreamNumberHistogramStatistics> another) {
        throw new NotImplementedException();
    }

    public void end() {
    }

    public List<StreamNumberHistogramStatistics> getResult() {
        return this.stats;
    }
}

