/*
 * Decompiled with CFR 0.152.
 */
package org.talend.dataprep.api.dataset.statistics.number;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeMap;
import org.talend.dataquality.statistics.numeric.histogram.Range;

public class StreamNumberHistogramStatistics {
    private static final int DEFAULT_BIN_NUMBER = 32;
    private int numberOfBins = 32;
    private long[] regulars;
    private Map<Double, Long> singulars = new HashMap<Double, Long>();
    private double min = Double.NaN;
    private double max = Double.NaN;
    private double lowerBound = Double.NaN;
    private double binSize = Double.NaN;
    private long numberOfValues;
    private boolean singular = true;
    private double sum = Double.NaN;

    public void add(double d) {
        if (this.singulars != null && (this.singulars.size() < this.numberOfBins || this.singulars.containsKey(d))) {
            this.singularAdd(d);
        } else {
            this.regularAdd(d);
        }
    }

    private void singularAdd(double d) {
        Long count = this.singulars.get(d);
        if (count == null) {
            this.singulars.put(d, 1L);
        } else {
            this.singulars.put(d, count + 1L);
        }
        if (Double.isNaN(this.min) || d < this.min) {
            this.lowerBound = this.min = d;
        }
        if (Double.isNaN(this.max) || this.max < d) {
            this.max = d;
        }
        ++this.numberOfValues;
        this.sum = Double.isNaN(this.sum) ? d : this.sum + d;
    }

    private void regularAdd(double d) {
        int bin;
        if (this.singular) {
            this.turnSingularsToRegulars();
            this.singulars = null;
            this.singular = false;
        }
        if (d < this.lowerBound) {
            this.extendToLeft(d);
        } else if (this.lowerBound + (double)this.numberOfBins * this.binSize <= d) {
            this.extendToRight(d);
        }
        if (d < this.min) {
            this.min = d;
        }
        if (this.max < d) {
            this.max = d;
        }
        int n = bin = (int)((d - this.lowerBound) / this.binSize);
        this.regulars[n] = this.regulars[n] + 1L;
        ++this.numberOfValues;
        this.sum += d;
    }

    private void turnSingularsToRegulars() {
        this.regulars = new long[this.numberOfBins];
        double histogramSize = (this.max - this.min) * 2.0;
        this.binSize = histogramSize / (double)this.numberOfBins;
        if (this.binSize > 1.0) {
            this.binSize = Math.ceil(this.binSize);
            this.lowerBound = Math.floor(this.min);
        } else {
            double accurateDouble = 1.0;
            while (this.binSize < accurateDouble / 2.0) {
                accurateDouble /= 2.0;
            }
            this.binSize = accurateDouble;
            this.lowerBound = Math.floor(this.min);
            if (this.lowerBound + (double)this.numberOfBins * this.binSize <= this.max) {
                this.lowerBound = this.min;
            }
        }
        for (int i = 0; i < this.numberOfBins; ++i) {
            this.regulars[i] = 0L;
        }
        for (Map.Entry<Double, Long> entry : this.singulars.entrySet()) {
            int bin;
            int n = bin = (int)((entry.getKey() - this.lowerBound) / this.binSize);
            this.regulars[n] = this.regulars[n] + entry.getValue();
        }
    }

    private void extendToLeft(double d) {
        double histogramWidth = (double)this.numberOfBins * this.binSize;
        long factor = 2L;
        while (d < this.lowerBound - histogramWidth * (double)(factor >>> 1)) {
            factor <<= 1;
        }
        this.binSize *= (double)factor;
        int offset = (int)(histogramWidth * (double)(factor >>> 1) / this.binSize);
        this.lowerBound -= histogramWidth * (double)(factor >>> 1);
        this.merge(factor, offset);
    }

    private void extendToRight(double d) {
        double histogramWidth = (double)this.numberOfBins * this.binSize;
        int factor = 2;
        while (this.lowerBound + histogramWidth * (double)factor <= d) {
            factor <<= 1;
        }
        this.binSize *= (double)factor;
        this.merge(factor, 0);
    }

    private void merge(long factor, int offset) {
        long count;
        int k = 0;
        int i = 0;
        while (i < this.numberOfBins) {
            count = 0L;
            for (int j = i; (long)j < (long)i + factor && j < this.numberOfBins; ++j) {
                count += this.regulars[j];
                this.regulars[j] = 0L;
            }
            this.regulars[k++] = count;
            long temp = (long)i + factor;
            if (temp < (long)this.numberOfBins) {
                i += (int)factor;
                continue;
            }
            i = this.numberOfBins;
        }
        if (0 < offset) {
            for (i = this.numberOfBins - 1 - offset; 0 <= i; --i) {
                count = this.regulars[i];
                this.regulars[i] = 0L;
                this.regulars[i + offset] = count;
            }
        }
    }

    public Map<Range, Long> getHistogram() {
        if (this.singular) {
            return this.getSingularHistogram();
        }
        LinkedHashMap<Range, Long> result = new LinkedHashMap<Range, Long>();
        int start = this.firstNonEmptyBin();
        int end = this.lastNonEmptyBin();
        for (int i = start; i <= end; ++i) {
            double d = this.lowerBound + this.binSize * (double)i;
            Range r = new Range(d, d + this.binSize);
            result.put(r, this.regulars[i]);
        }
        return result;
    }

    private Map<Range, Long> getSingularHistogram() {
        LinkedHashMap<Range, Long> result = new LinkedHashMap<Range, Long>();
        TreeMap<Double, Long> bins = new TreeMap<Double, Long>(this.singulars);
        for (Number n : bins.keySet()) {
            double d = (Double)n;
            Range r = new Range(d, d);
            result.put(r, (Long)bins.get(d));
        }
        return result;
    }

    private int firstNonEmptyBin() {
        int start = 0;
        for (int i = 0; i < this.numberOfBins && this.regulars[i] == 0L; ++i) {
            ++start;
        }
        return start;
    }

    private int lastNonEmptyBin() {
        int end = this.numberOfBins - 1;
        for (int i = this.numberOfBins - 1; i >= 0 && this.regulars[i] == 0L; --i) {
            --end;
        }
        return end;
    }

    public double getMin() {
        return Double.isNaN(this.min) ? 0.0 : this.min;
    }

    public double getMax() {
        return Double.isNaN(this.max) ? 0.0 : this.max;
    }

    public double getMean() {
        return Double.isNaN(this.sum) ? 0.0 : this.sum / (double)this.numberOfValues;
    }

    public int getNumberOfBins() {
        return this.numberOfBins;
    }

    public void setNumberOfBins(int numberOfBins) {
        if (numberOfBins <= 0) {
            throw new IllegalArgumentException("The number of bin must be a positive integer and a power of 2");
        }
        if ((numberOfBins & numberOfBins - 1) != 0) {
            throw new IllegalArgumentException("The number of bin which is " + numberOfBins + " must be a power of 2");
        }
        this.numberOfBins = numberOfBins;
    }

    public long getNumberOfValues() {
        return this.numberOfValues;
    }
}

