/*
 * Decompiled with CFR 0.152.
 */
package org.talend.dataprep.api.filter;

import java.util.function.Predicate;
import org.apache.commons.lang.StringUtils;
import org.talend.daikon.exception.TalendRuntimeException;
import org.talend.daikon.exception.error.ErrorCode;
import org.talend.dataprep.BaseErrorCodes;
import org.talend.dataprep.api.dataset.RowMetadata;
import org.talend.dataprep.api.dataset.row.DataSetRow;
import org.talend.dataprep.api.filter.FilterService;
import org.talend.dataprep.api.filter.SimpleFilterService;
import org.talend.dataprep.api.filter.TQLFilterService;

public class PolyglotFilterService
implements FilterService {
    private final SimpleFilterService jsonFilterService = new SimpleFilterService();
    private final TQLFilterService tqlFilterService = new TQLFilterService();

    @Override
    public Predicate<DataSetRow> build(String filterAsString, RowMetadata rowMetadata) {
        if (StringUtils.isBlank((String)filterAsString)) {
            return row -> true;
        }
        try {
            return this.selectFilterService(filterAsString).build(filterAsString, rowMetadata);
        }
        catch (Exception e) {
            throw new TalendRuntimeException((ErrorCode)BaseErrorCodes.UNABLE_TO_PARSE_FILTER, (Throwable)e);
        }
    }

    private FilterService selectFilterService(String filterAsString) {
        if (filterAsString.startsWith("{")) {
            return this.jsonFilterService;
        }
        return this.tqlFilterService;
    }
}

