/*
 * Decompiled with CFR 0.152.
 */
package org.talend.dataprep.api.filter;

import java.util.List;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang.NotImplementedException;
import org.apache.commons.lang.StringUtils;
import org.talend.daikon.number.BigDecimalParser;
import org.talend.dataprep.api.dataset.RowMetadata;
import org.talend.dataprep.api.dataset.row.DataSetRow;
import org.talend.dataprep.api.filter.FilterService;
import org.talend.tql.model.AllFields;
import org.talend.tql.model.AndExpression;
import org.talend.tql.model.ComparisonExpression;
import org.talend.tql.model.ComparisonOperator;
import org.talend.tql.model.Expression;
import org.talend.tql.model.FieldBetweenExpression;
import org.talend.tql.model.FieldCompliesPattern;
import org.talend.tql.model.FieldContainsExpression;
import org.talend.tql.model.FieldInExpression;
import org.talend.tql.model.FieldIsEmptyExpression;
import org.talend.tql.model.FieldIsInvalidExpression;
import org.talend.tql.model.FieldIsValidExpression;
import org.talend.tql.model.FieldMatchesRegex;
import org.talend.tql.model.FieldReference;
import org.talend.tql.model.LiteralValue;
import org.talend.tql.model.NotExpression;
import org.talend.tql.model.OrExpression;
import org.talend.tql.model.TqlElement;
import org.talend.tql.parser.Tql;
import org.talend.tql.visitor.IASTVisitor;

public class TQLFilterService
implements FilterService {
    @Override
    public Predicate<DataSetRow> build(String filterAsString, RowMetadata rowMetadata) {
        Expression parsedPredicate = Tql.parse((String)filterAsString);
        return (Predicate)parsedPredicate.accept((IASTVisitor)new DataSetPredicateVisitor());
    }

    private static class DataSetPredicateVisitor
    implements IASTVisitor {
        private DataSetPredicateVisitor() {
        }

        public Object visit(TqlElement tqlElement) {
            return null;
        }

        public Object visit(ComparisonOperator comparisonOperator) {
            throw new NotImplementedException();
        }

        public Object visit(LiteralValue literalValue) {
            return literalValue.getValue();
        }

        public Object visit(FieldReference fieldReference) {
            return fieldReference.getPath();
        }

        public Object visit(Expression expression) {
            throw new NotImplementedException();
        }

        public Object visit(AndExpression andExpression) {
            Predicate predicate = null;
            for (Expression expression : andExpression.getExpressions()) {
                predicate = predicate != null ? predicate.and((Predicate)expression.accept((IASTVisitor)this)) : (Predicate)expression.accept((IASTVisitor)this);
            }
            return predicate;
        }

        public Object visit(OrExpression orExpression) {
            Predicate predicate = null;
            for (Expression expression : orExpression.getExpressions()) {
                predicate = predicate != null ? predicate.or((Predicate)expression.accept((IASTVisitor)this)) : (Predicate)expression.accept((IASTVisitor)this);
            }
            return predicate;
        }

        public Predicate<DataSetRow> visit(ComparisonExpression comparisonExpression) {
            ComparisonOperator.Enum operator = comparisonExpression.getOperator().getOperator();
            String columnName = (String)comparisonExpression.getField().accept((IASTVisitor)this);
            String value = (String)comparisonExpression.getValueOrField().accept((IASTVisitor)this);
            switch (operator) {
                case EQ: {
                    return row -> StringUtils.equals((String)row.get(columnName), (String)value);
                }
                case LT: {
                    return row -> BigDecimalParser.toBigDecimal((String)row.get(columnName)).compareTo(BigDecimalParser.toBigDecimal((String)value)) < 0;
                }
                case GT: {
                    return row -> BigDecimalParser.toBigDecimal((String)row.get(columnName)).compareTo(BigDecimalParser.toBigDecimal((String)value)) > 0;
                }
                case NEQ: {
                    return row -> !StringUtils.equals((String)row.get(columnName), (String)value);
                }
                case LET: {
                    return row -> BigDecimalParser.toBigDecimal((String)row.get(columnName)).compareTo(BigDecimalParser.toBigDecimal((String)value)) <= 0;
                }
                case GET: {
                    return row -> BigDecimalParser.toBigDecimal((String)row.get(columnName)).compareTo(BigDecimalParser.toBigDecimal((String)value)) >= 0;
                }
            }
            return null;
        }

        public Predicate<DataSetRow> visit(FieldInExpression fieldInExpression) {
            String fieldName = ((FieldReference)fieldInExpression.getField()).getPath();
            List collect = Stream.of(fieldInExpression.getValues()).map(LiteralValue::getValue).collect(Collectors.toList());
            return row -> collect.contains(row.get(fieldName));
        }

        public Predicate<DataSetRow> visit(FieldIsEmptyExpression fieldIsEmptyExpression) {
            String fieldName = ((FieldReference)fieldIsEmptyExpression.getField()).getPath();
            return row -> StringUtils.isBlank((String)row.get(fieldName));
        }

        public Predicate<DataSetRow> visit(FieldIsValidExpression fieldIsValidExpression) {
            String fieldName = ((FieldReference)fieldIsValidExpression.getField()).getPath();
            return row -> row.isInvalid(fieldName);
        }

        public Predicate<DataSetRow> visit(FieldIsInvalidExpression fieldIsInvalidExpression) {
            String fieldName = ((FieldReference)fieldIsInvalidExpression.getField()).getPath();
            return row -> !row.isInvalid(fieldName);
        }

        public Predicate<DataSetRow> visit(FieldMatchesRegex fieldMatchesRegex) {
            String fieldName = ((FieldReference)fieldMatchesRegex.getField()).getPath();
            String regex = fieldMatchesRegex.getRegex();
            Pattern pattern = Pattern.compile(regex);
            return row -> pattern.matcher(row.get(fieldName)).matches();
        }

        public Object visit(FieldCompliesPattern fieldCompliesPattern) {
            throw new NotImplementedException();
        }

        public Predicate<DataSetRow> visit(FieldBetweenExpression fieldBetweenExpression) {
            String fieldName = ((FieldReference)fieldBetweenExpression.getField()).getPath();
            String low = fieldBetweenExpression.getLeft().getValue();
            String high = fieldBetweenExpression.getRight().getValue();
            return row -> BigDecimalParser.toBigDecimal((String)row.get(fieldName)).compareTo(BigDecimalParser.toBigDecimal((String)low)) < 0 && BigDecimalParser.toBigDecimal((String)row.get(fieldName)).compareTo(BigDecimalParser.toBigDecimal((String)high)) > 0;
        }

        public Predicate<DataSetRow> visit(NotExpression notExpression) {
            return ((Predicate)notExpression.accept((IASTVisitor)this)).negate();
        }

        public Predicate<DataSetRow> visit(FieldContainsExpression fieldContainsExpression) {
            String fieldName = ((FieldReference)fieldContainsExpression.getField()).getPath();
            String value = fieldContainsExpression.getValue();
            return row -> StringUtils.contains((String)row.get(fieldName), (String)value);
        }

        public Object visit(AllFields allFields) {
            throw new UnsupportedOperationException("Not implemented.");
        }
    }
}

