/*
 * Decompiled with CFR 0.152.
 */
package org.talend.dataprep.api.preparation;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonRootName;
import java.io.Serializable;
import java.util.Map;
import java.util.Objects;
import org.talend.dataprep.api.preparation.MixedContentMap;

@JsonRootName(value="action")
@JsonPropertyOrder(value={"action", "parameters"})
public class Action
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String action;
    private MixedContentMap parameters = new MixedContentMap();

    @JsonProperty(value="action")
    public String getName() {
        return this.action;
    }

    @JsonProperty(value="action")
    public void setName(String action) {
        this.action = action;
    }

    public Map<String, String> getParameters() {
        return this.parameters;
    }

    public void setParameters(MixedContentMap parameters) {
        this.parameters = parameters;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Action action1 = (Action)o;
        return Objects.equals(this.action, action1.action) && Objects.equals(this.parameters, action1.parameters);
    }

    public String toString() {
        return "Action{action='" + this.action + '\'' + ", parameters=" + this.parameters + '}';
    }

    public int hashCode() {
        return Objects.hash(this.action, this.parameters);
    }

    public static class Builder {
        private Map<String, String> parameters;
        private String name;

        public static Builder builder() {
            return new Builder();
        }

        public Action build() {
            Action builtAction = new Action();
            builtAction.getParameters().putAll(this.parameters);
            builtAction.setName(this.name);
            return builtAction;
        }

        public Builder withParameters(Map<String, String> parameters) {
            this.parameters = parameters;
            return this;
        }

        public Builder withName(String name) {
            this.name = name;
            return this;
        }
    }
}

