/*
 * Decompiled with CFR 0.152.
 */
package org.talend.dataprep.api.preparation;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.talend.dataprep.api.dataset.RowMetadata;
import org.talend.dataprep.api.preparation.BasicUserLock;
import org.talend.dataprep.api.preparation.Identifiable;
import org.talend.dataprep.api.preparation.Step;

public class Preparation
extends Identifiable
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String dataSetId;
    @NotNull
    private RowMetadata rowMetadata;
    private String author;
    private String name;
    private long creationDate;
    private long lastModificationDate;
    private String headId;
    @JsonProperty(value="app-version")
    private String appVersion;
    private List<Step> steps = Collections.singletonList(Step.ROOT_STEP);
    private BasicUserLock lock;

    public Preparation() {
    }

    @JsonCreator
    public Preparation(@JsonProperty(value="id") String id, @JsonProperty(value="app-version") String appVersion) {
        this.id = id;
        this.lastModificationDate = this.creationDate = System.currentTimeMillis();
        this.appVersion = appVersion;
    }

    public Preparation(String id, String dataSetId, String headId, String appVersion) {
        this(id, appVersion);
        this.dataSetId = dataSetId;
        this.headId = headId;
    }

    public Preparation(Preparation origin) {
        this.dataSetId = origin.dataSetId;
        this.rowMetadata = origin.rowMetadata;
        this.author = origin.author;
        this.name = origin.name;
        this.creationDate = origin.creationDate;
        this.lastModificationDate = origin.lastModificationDate;
        this.headId = origin.headId;
        this.appVersion = origin.appVersion;
        this.steps = origin.steps;
    }

    public List<Step> getSteps() {
        return this.steps;
    }

    public void setSteps(List<Step> steps) {
        this.steps = steps;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDataSetId() {
        return this.dataSetId;
    }

    public void setDataSetId(String dataSetId) {
        this.dataSetId = dataSetId;
    }

    public RowMetadata getRowMetadata() {
        return this.rowMetadata;
    }

    public void setRowMetadata(RowMetadata rowMetadata) {
        this.rowMetadata = rowMetadata;
    }

    public String getAuthor() {
        return this.author;
    }

    public void setAuthor(String author) {
        this.author = author;
    }

    public long getCreationDate() {
        return this.creationDate;
    }

    public void setCreationDate(long creationDate) {
        this.creationDate = creationDate;
    }

    public long getLastModificationDate() {
        return this.lastModificationDate;
    }

    public void setLastModificationDate(long lastModificationDate) {
        this.lastModificationDate = lastModificationDate;
    }

    public String getHeadId() {
        return this.headId;
    }

    public void setHeadId(String headId) {
        this.headId = headId;
    }

    @Override
    public String id() {
        return this.getId();
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    public String getAppVersion() {
        return this.appVersion;
    }

    public void setAppVersion(String appVersion) {
        this.appVersion = appVersion;
    }

    public BasicUserLock getLock() {
        return this.lock;
    }

    public void setLock(BasicUserLock lock) {
        this.lock = lock;
    }

    public void updateLastModificationDate() {
        this.lastModificationDate = System.currentTimeMillis();
    }

    public Preparation merge(Preparation other) {
        Preparation merge = new Preparation(this.id, other.getAppVersion());
        merge.dataSetId = other.dataSetId != null ? other.dataSetId : this.dataSetId;
        merge.rowMetadata = other.rowMetadata != null ? other.rowMetadata : this.rowMetadata;
        merge.author = other.author != null ? other.author : this.author;
        merge.name = other.name != null ? other.name : this.name;
        merge.creationDate = Math.min(other.creationDate, this.creationDate);
        merge.lastModificationDate = Math.max(other.lastModificationDate, this.lastModificationDate);
        merge.headId = other.headId != null ? other.headId : this.headId;
        merge.lock = other.lock != null ? other.lock : this.lock;
        return merge;
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("id", (Object)this.id).append("dataSetId", (Object)this.dataSetId).append("author", (Object)this.author).append("name", (Object)this.name).append("creationDate", this.creationDate).append("lastModificationDate", this.lastModificationDate).append("headId", (Object)this.headId).toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Preparation that = (Preparation)o;
        return Objects.equals(this.id, that.id) && Objects.equals(this.rowMetadata, that.rowMetadata) && Objects.equals(this.creationDate, that.creationDate) && Objects.equals(this.lastModificationDate, that.lastModificationDate) && Objects.equals(this.dataSetId, that.dataSetId) && Objects.equals(this.author, that.author) && Objects.equals(this.name, that.name) && Objects.equals(this.headId, that.headId);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.rowMetadata, this.dataSetId, this.author, this.name, this.creationDate, this.lastModificationDate, this.headId);
    }
}

