/*
 * Decompiled with CFR 0.152.
 */
package org.talend.dataprep.api.preparation;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.commons.codec.digest.DigestUtils;
import org.talend.dataprep.api.preparation.Action;
import org.talend.dataprep.api.preparation.Identifiable;

public class PreparationActions
extends Identifiable
implements Serializable {
    public static final PreparationActions ROOT_ACTIONS = new PreparationActions("cdcd5c9a3a475f2298b5ee3f4258f8207ba10879");
    private static final long serialVersionUID = 1L;
    private List<Action> actions = Collections.emptyList();
    @JsonProperty(value="app-version")
    private String appVersion;

    private PreparationActions(String id) {
        this.id = id;
    }

    public PreparationActions() {
    }

    public PreparationActions(List<Action> actions, String appVersion) {
        this.actions = Collections.unmodifiableList(actions);
        this.appVersion = appVersion;
    }

    public PreparationActions append(List<Action> newActions) {
        ArrayList<Action> appendedActions = new ArrayList<Action>(this.getActions().size() + newActions.size());
        appendedActions.addAll(this.actions);
        appendedActions.addAll(newActions);
        return new PreparationActions(appendedActions, this.getAppVersion());
    }

    @Override
    public String id() {
        return this.getId();
    }

    @Override
    public String getId() {
        if (this.id == null) {
            this.id = DigestUtils.sha1Hex((String)Integer.toString(this.hashCode()));
        }
        return this.id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    public List<Action> getActions() {
        return this.actions;
    }

    public void setActions(List<Action> actions) {
        this.actions = actions;
    }

    public String getAppVersion() {
        return this.appVersion;
    }

    public void setAppVersion(String appVersion) {
        this.appVersion = appVersion;
    }

    public String toString() {
        return "PreparationActions{id='" + this.id + '\'' + ", actions=" + this.actions + ", appVersion='" + this.appVersion + '\'' + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PreparationActions that = (PreparationActions)o;
        return Objects.equals(this.getId(), that.getId());
    }

    public int hashCode() {
        return Objects.hash(this.actions, this.appVersion);
    }
}

