/*
 * Decompiled with CFR 0.152.
 */
package org.talend.dataprep.api.preparation;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import java.util.Objects;
import java.util.UUID;
import org.talend.dataprep.api.preparation.Identifiable;
import org.talend.dataprep.api.preparation.PreparationActions;
import org.talend.dataprep.api.preparation.StepDiff;

public class Step
extends Identifiable
implements Serializable {
    public static final Step ROOT_STEP = new Step("f6e172c33bdacbc69bca9d32b2bd78174712a171");
    private static final long serialVersionUID = 1L;
    private String parent = "f6e172c33bdacbc69bca9d32b2bd78174712a171";
    private String preparationActions = PreparationActions.ROOT_ACTIONS.id();
    @JsonProperty(value="app-version")
    private String appVersion;
    private StepDiff diff;
    private String rowMetadata;

    public Step() {
    }

    private Step(String id) {
        this.id = id;
    }

    public Step(String parent, String content, String appVersion) {
        this(parent, content, appVersion, null);
    }

    public Step(String parent, String content, String appVersion, StepDiff diff) {
        this.id = UUID.randomUUID().toString();
        this.parent = parent;
        this.preparationActions = content;
        this.appVersion = appVersion;
        this.diff = diff;
    }

    public String getParent() {
        return this.parent;
    }

    public void setParent(String parent) {
        this.parent = parent;
    }

    public StepDiff getDiff() {
        return this.diff;
    }

    public void setDiff(StepDiff diff) {
        this.diff = diff;
    }

    public String getAppVersion() {
        return this.appVersion;
    }

    @Override
    public String id() {
        return this.getId();
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        if (Step.ROOT_STEP.id.equals(id)) {
            this.parent = null;
        }
        this.id = id;
    }

    public String getContent() {
        return this.preparationActions == null ? PreparationActions.ROOT_ACTIONS.id() : this.preparationActions;
    }

    public void setContent(String preparationActions) {
        if (ROOT_STEP.id().equals(this.id) && !PreparationActions.ROOT_ACTIONS.id().equals(preparationActions)) {
            throw new IllegalArgumentException("Preparation action '" + preparationActions + "' is not valid for root step.");
        }
        this.preparationActions = preparationActions;
    }

    public String getRowMetadata() {
        return this.rowMetadata;
    }

    public void setRowMetadata(String rowMetadata) {
        this.rowMetadata = rowMetadata;
    }

    public String toString() {
        String result = "Step{parentId='";
        result = this.parent != null ? result + this.parent : result + "null";
        result = result + "', actions='" + this.preparationActions + '\'' + ", appVersion='" + this.appVersion + '\'' + ", diff=" + this.diff + '}';
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Step step = (Step)o;
        return Objects.equals(this.getId(), step.getId());
    }

    public int hashCode() {
        return Objects.hash(this.parent, this.preparationActions, this.rowMetadata, this.appVersion, this.diff);
    }

    static {
        Step.ROOT_STEP.parent = null;
    }
}

