/*
 * Decompiled with CFR 0.152.
 */
package org.talend.dataprep.api.preparation.json;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.module.SimpleModule;
import java.io.IOException;
import java.util.Map;
import org.talend.dataprep.api.preparation.MixedContentMap;

public class MixedContentMapModule
extends SimpleModule {
    public MixedContentMapModule() {
        super(MixedContentMapModule.class.getName(), new Version(1, 0, 0, null, null, null));
        this.addSerializer(MixedContentMap.class, new Serializer());
        this.addDeserializer(MixedContentMap.class, new Deserializer());
    }

    private class Deserializer
    extends JsonDeserializer<MixedContentMap> {
        private Deserializer() {
        }

        public MixedContentMap deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
            JsonToken token;
            MixedContentMap map = new MixedContentMap();
            String currentKey = null;
            while ((token = jsonParser.nextToken()) != null && token != JsonToken.END_OBJECT) {
                if (currentKey != null) {
                    if (token == JsonToken.VALUE_STRING) {
                        map.put(currentKey, jsonParser.getValueAsString());
                    } else if (token == JsonToken.VALUE_NUMBER_INT) {
                        map.put(currentKey, String.valueOf(jsonParser.getValueAsInt()));
                    } else if (token == JsonToken.VALUE_NUMBER_FLOAT) {
                        map.put(currentKey, String.valueOf(jsonParser.getValueAsDouble()));
                    } else if (token == JsonToken.VALUE_TRUE || token == JsonToken.VALUE_FALSE) {
                        map.put(currentKey, String.valueOf(jsonParser.getValueAsBoolean()));
                    } else if (token == JsonToken.START_OBJECT || token == JsonToken.START_ARRAY) {
                        map.put(currentKey, jsonParser.readValueAsTree().toString());
                        jsonParser.skipChildren();
                    } else if (token == JsonToken.VALUE_NULL) {
                        map.put(currentKey, null);
                    }
                    currentKey = null;
                    continue;
                }
                if (token != JsonToken.FIELD_NAME) continue;
                currentKey = jsonParser.getCurrentName();
            }
            return map;
        }
    }

    private class Serializer
    extends JsonSerializer<MixedContentMap> {
        private Serializer() {
        }

        public void serialize(MixedContentMap map, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
            jsonGenerator.writeStartObject();
            for (Map.Entry<String, String> entry : map.entrySet()) {
                jsonGenerator.writeFieldName(entry.getKey());
                String value = entry.getValue();
                if (value == null) {
                    jsonGenerator.writeNull();
                    continue;
                }
                if (value.isEmpty()) {
                    jsonGenerator.writeString("");
                    continue;
                }
                if (value.charAt(0) == '{' || value.charAt(0) == '[') {
                    try {
                        boolean actualJson;
                        JsonNode node = new ObjectMapper().reader().readTree(value);
                        if (value.charAt(0) == '{') {
                            actualJson = node.isContainerNode() && value.endsWith("}");
                        } else {
                            boolean bl = actualJson = node.isArray() && value.endsWith("]");
                        }
                        if (actualJson) {
                            jsonGenerator.writeRawValue(value);
                            continue;
                        }
                        jsonGenerator.writeString(value);
                    }
                    catch (IOException ioe) {
                        jsonGenerator.writeString(value);
                    }
                    continue;
                }
                jsonGenerator.writeString(value);
            }
            jsonGenerator.writeEndObject();
        }
    }
}

