/*
 * Decompiled with CFR 0.152.
 */
package org.talend.dataprep.api.type;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.IOException;
import java.io.Serializable;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;

@JsonSerialize(using=TypeSerializer.class)
public enum Type implements Serializable
{
    ANY("any", "ANY"),
    STRING("string", ANY, "STRING"),
    BOOLEAN("boolean", STRING, "BOOLEAN"),
    DATE("date", STRING, "DATE"),
    UTC_DATETIME("utc_datetime", STRING, "UTC_DATETIME"),
    NUMERIC("numeric", STRING, "NUMERIC"),
    DOUBLE("double", NUMERIC, "DOUBLE"),
    INTEGER("integer", NUMERIC, "INTEGER"),
    FLOAT("float", NUMERIC, "FLOAT");

    private static final long serialVersionUID = 1L;
    private final String name;
    private final String labelKey;
    private final Type superType;
    private final List<Type> subTypes = new LinkedList<Type>();

    private Type(String name, String labelKey) {
        this(name, null, labelKey);
    }

    private Type(String name, Type superType, String labelKey) {
        this.name = name;
        this.superType = superType;
        this.labelKey = labelKey;
        if (superType != null) {
            superType.declareSubType(this);
        }
    }

    void declareSubType(Type type) {
        this.subTypes.add(type);
    }

    public String getName() {
        return this.name;
    }

    public Type getSuperType() {
        return this.superType;
    }

    private String getLabelKey() {
        return this.labelKey;
    }

    public List<Type> list() {
        LinkedList<Type> list = new LinkedList<Type>();
        list.add(this);
        this.subTypes.forEach(type -> list.addAll(type.list()));
        return list;
    }

    public String toString() {
        return this.name;
    }

    public boolean isAssignableFrom(Type type) {
        return this.list().contains(type);
    }

    public boolean isAssignableFrom(String type) {
        return this.list().contains(Type.get(type));
    }

    public static Type get(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Name cannot be null.");
        }
        List<Type> types = ANY.list();
        Optional<Type> type = types.stream().filter(type1 -> type1.getName().equalsIgnoreCase(name)).findFirst();
        if (type.isPresent()) {
            return type.get();
        }
        return STRING;
    }

    public static boolean has(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Name cannot be null.");
        }
        List<Type> types = ANY.list();
        Optional<Type> type = types.stream().filter(type1 -> type1.getName().equalsIgnoreCase(name)).findFirst();
        return type.isPresent();
    }

    public static class TypeSerializer
    extends JsonSerializer<Type> {
        public void serialize(Type value, JsonGenerator jgen, SerializerProvider provider) throws IOException {
            jgen.writeStartObject();
            jgen.writeStringField("id", value.name());
            jgen.writeStringField("name", value.getName());
            jgen.writeStringField("labelKey", value.getLabelKey());
            jgen.writeEndObject();
        }
    }
}

