/*
 * Decompiled with CFR 0.152.
 */
package org.talend.dataprep.api.type;

import java.util.List;
import org.talend.dataprep.api.dataset.ColumnMetadata;
import org.talend.dataprep.api.type.Type;
import org.talend.dataquality.semantic.api.CategoryRegistryManager;
import org.talend.dataquality.semantic.model.DQCategory;
import org.talend.dataquality.statistics.type.DataTypeEnum;

public class TypeUtils {
    private TypeUtils() {
    }

    public static DataTypeEnum[] convert(List<ColumnMetadata> columns) {
        DataTypeEnum[] types = new DataTypeEnum[columns.size()];
        for (int i = 0; i < columns.size(); ++i) {
            String type = columns.get(i).getType();
            types[i] = TypeUtils.convert(Type.get(type));
        }
        return types;
    }

    private static DataTypeEnum convert(Type type) {
        switch (type) {
            case ANY: 
            case STRING: {
                return DataTypeEnum.STRING;
            }
            case NUMERIC: {
                return DataTypeEnum.INTEGER;
            }
            case INTEGER: {
                return DataTypeEnum.INTEGER;
            }
            case DOUBLE: 
            case FLOAT: {
                return DataTypeEnum.DOUBLE;
            }
            case BOOLEAN: {
                return DataTypeEnum.BOOLEAN;
            }
            case DATE: {
                return DataTypeEnum.DATE;
            }
        }
        return DataTypeEnum.STRING;
    }

    public static String getDomainLabel(String categoryId) {
        DQCategory category = CategoryRegistryManager.getInstance().getCategoryMetadataByName(categoryId);
        return category == null ? "" : category.getLabel();
    }
}

