/*
 * Decompiled with CFR 0.152.
 */
package org.talend.dataprep.date;

import java.io.Serializable;
import java.time.DayOfWeek;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.Month;
import java.time.YearMonth;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.time.temporal.IsoFields;
import java.time.temporal.TemporalAdjusters;
import java.util.Arrays;

public class DateManipulator
implements Serializable {
    private DateManipulator() {
    }

    public static Pace getSuitablePace(LocalDateTime min, LocalDateTime max, int maxNumberOfParts) {
        long allRangeTimetamp = Duration.between(min, max).toMillis();
        return Arrays.stream(Pace.values()).filter(pace -> allRangeTimetamp / pace.getTime() < (long)(maxNumberOfParts - 1)).findFirst().orElse(null);
    }

    public static LocalDateTime getSuitableStartingDate(LocalDateTime date, Pace pace) {
        switch (pace) {
            case CENTURY: {
                return DateManipulator.getFirstDayOfCentury(date);
            }
            case DECADE: {
                return DateManipulator.getFirstDayOfDecade(date);
            }
            case YEAR: {
                return DateManipulator.getFirstDayOfYear(date);
            }
            case HALF_YEAR: {
                return DateManipulator.getFirstDayOfHalfYear(date);
            }
            case QUARTER: {
                return DateManipulator.getFirstDayOfQuarter(date);
            }
            case MONTH: {
                return DateManipulator.getFirstDayOfMonth(date);
            }
            case WEEK: {
                return DateManipulator.getFirstDayOfWeek(date);
            }
        }
        return DateManipulator.getStartOfDay(date);
    }

    public static LocalDateTime getNext(LocalDateTime localDate, Pace pace) {
        switch (pace) {
            case CENTURY: {
                return localDate.plus(100L, ChronoUnit.YEARS);
            }
            case DECADE: {
                return localDate.plus(10L, ChronoUnit.YEARS);
            }
            case YEAR: {
                return localDate.plus(1L, ChronoUnit.YEARS);
            }
            case HALF_YEAR: {
                return localDate.plus(6L, ChronoUnit.MONTHS);
            }
            case QUARTER: {
                return localDate.plus(3L, ChronoUnit.MONTHS);
            }
            case MONTH: {
                return localDate.plus(1L, ChronoUnit.MONTHS);
            }
            case WEEK: {
                return localDate.plus(1L, ChronoUnit.WEEKS);
            }
            case DAY: {
                return localDate.plus(1L, ChronoUnit.DAYS);
            }
        }
        return localDate;
    }

    private static LocalDateTime getFirstDayOfCentury(LocalDateTime localDate) {
        return localDate.with(temporal -> {
            int year = localDate.getYear() / 100 * 100;
            return LocalDate.from(temporal).withYear(year).atStartOfDay().with(TemporalAdjusters.firstDayOfYear());
        });
    }

    private static LocalDateTime getFirstDayOfDecade(LocalDateTime localDate) {
        return localDate.with(temporal -> {
            int year = localDate.getYear() / 10 * 10;
            return LocalDate.from(temporal).withYear(year).atStartOfDay().with(TemporalAdjusters.firstDayOfYear());
        });
    }

    private static LocalDateTime getFirstDayOfYear(LocalDateTime localDate) {
        return localDate.with(temporal -> LocalDate.from(temporal).atStartOfDay().with(TemporalAdjusters.firstDayOfYear()));
    }

    private static LocalDateTime getFirstDayOfHalfYear(LocalDateTime localDate) {
        return localDate.with(temporal -> {
            Month semesterMonth = localDate.getMonth().getValue() < Month.JULY.getValue() ? Month.JANUARY : Month.JULY;
            return LocalDate.from(temporal).withMonth(semesterMonth.getValue()).atStartOfDay().with(TemporalAdjusters.firstDayOfMonth());
        });
    }

    private static LocalDateTime getFirstDayOfQuarter(LocalDateTime localDate) {
        return localDate.with(temporal -> {
            int currentQuarter = YearMonth.from(temporal).get(IsoFields.QUARTER_OF_YEAR);
            switch (currentQuarter) {
                case 1: {
                    return LocalDate.from(temporal).atStartOfDay().with(TemporalAdjusters.firstDayOfYear());
                }
                case 2: {
                    return LocalDate.from(temporal).atStartOfDay().withMonth(Month.APRIL.getValue()).with(TemporalAdjusters.firstDayOfMonth());
                }
                case 3: {
                    return LocalDate.from(temporal).atStartOfDay().withMonth(Month.JULY.getValue()).with(TemporalAdjusters.firstDayOfMonth());
                }
            }
            return LocalDate.from(temporal).atStartOfDay().withMonth(Month.OCTOBER.getValue()).with(TemporalAdjusters.firstDayOfMonth());
        });
    }

    private static LocalDateTime getFirstDayOfMonth(LocalDateTime localDate) {
        return localDate.with(temporal -> LocalDate.from(temporal).atStartOfDay().with(TemporalAdjusters.firstDayOfMonth()));
    }

    private static LocalDateTime getFirstDayOfWeek(LocalDateTime localDate) {
        return localDate.with(temporal -> LocalDate.from(temporal).atStartOfDay().with(DayOfWeek.MONDAY));
    }

    private static LocalDateTime getStartOfDay(LocalDateTime localDate) {
        return localDate.with(temporal -> LocalDate.from(temporal).atStartOfDay());
    }

    public static long getUTCEpochMilliseconds(LocalDateTime localDate) {
        return localDate.toEpochSecond(ZoneOffset.UTC) * 1000L;
    }

    public static LocalDateTime fromEpochMillisecondsWithSystemOffset(long epochMillis) {
        ZonedDateTime referenceUTC = ZonedDateTime.ofInstant(Instant.ofEpochMilli(epochMillis), ZoneId.systemDefault());
        long offsetMillis = referenceUTC.getOffset().getTotalSeconds() * 1000;
        return LocalDateTime.ofInstant(Instant.ofEpochMilli(epochMillis - offsetMillis), ZoneId.systemDefault());
    }

    public static enum Pace {
        DAY(86400000L),
        WEEK(604800000L),
        MONTH(2678400000L),
        QUARTER(7884000000L),
        HALF_YEAR(15768000000L),
        YEAR(31536000000L),
        DECADE(315360000000L),
        CENTURY(3153600000000L);

        private final long time;

        private Pace(long time) {
            this.time = time;
        }

        public long getTime() {
            return this.time;
        }
    }
}

