/*
 * Decompiled with CFR 0.152.
 */
package org.talend.dataprep.i18n;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.Objects;
import java.util.ResourceBundle;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.talend.daikon.exception.ExceptionContext;
import org.talend.daikon.exception.TalendRuntimeException;
import org.talend.daikon.exception.error.ErrorCode;
import org.talend.dataprep.BaseErrorCodes;
import org.talend.dataprep.i18n.MessagesBundle;

public class ActionsBundle
implements MessagesBundle {
    private static final ActionsBundle INSTANCE = new ActionsBundle();
    private static final Logger LOGGER = LoggerFactory.getLogger(ActionsBundle.class);
    private static final String ACTIONS_MESSAGES = "actions_messages";
    private static final String BUNDLE_NAME = "org.talend.dataprep.i18n.actions_messages";
    private static final String ACTION_PREFIX = "action.";
    private static final String DESCRIPTION_SUFFIX = ".desc";
    private static final String URL_SUFFIX = ".url";
    private static final String URL_PARAMETERS_SUFFIX = ".url_parameters";
    private static final String LABEL_SUFFIX = ".label";
    private static final String PARAMETER_PREFIX = "parameter.";
    private static final String CATEGORY_PREFIX = "category.";
    private static final String CHOICE_PREFIX = "choice.";
    private String documentationUrlBase;
    private Cache<CacheKey, String> cache = CacheBuilder.newBuilder().expireAfterAccess(10L, TimeUnit.MINUTES).maximumSize(1000L).build();

    public static void setGlobalDocumentationUrlBase(String documentationUrlBase) {
        INSTANCE.setDocumentationUrlBase(documentationUrlBase);
    }

    public static String getGlobalDocumentationUrlBase() {
        return INSTANCE.getDocumentationUrlBase();
    }

    public static String actionLabel(Object action, Locale locale, String actionName, Object ... values) {
        String actionLabelKey = ACTION_PREFIX + actionName + LABEL_SUFFIX;
        return INSTANCE.getMandatoryMessage(action, locale, actionLabelKey, values);
    }

    public static String actionDescription(Object action, Locale locale, String actionName, Object ... values) {
        String actionDescriptionKey = ACTION_PREFIX + actionName + DESCRIPTION_SUFFIX;
        return INSTANCE.getMandatoryMessage(action, locale, actionDescriptionKey, values);
    }

    public static String actionDocUrl(Object action, Locale locale, String actionName) {
        String actionDocUrlKey = ACTION_PREFIX + actionName + URL_SUFFIX;
        String docUrl = INSTANCE.getOptionalMessage(action, locale, actionDocUrlKey, new Object[0]);
        if (docUrl == null) {
            String docParameters = INSTANCE.getOptionalMessage(action, locale, ACTION_PREFIX + actionName + URL_PARAMETERS_SUFFIX, new Object[0]);
            if (ActionsBundle.INSTANCE.documentationUrlBase != null && docParameters != null) {
                return ActionsBundle.INSTANCE.documentationUrlBase + docParameters;
            }
            return "";
        }
        return docUrl;
    }

    public static String categoryName(Object action, Locale locale, String categoryName, Object ... values) {
        String categoryLabelKey = CATEGORY_PREFIX + categoryName + LABEL_SUFFIX;
        return INSTANCE.getMandatoryMessage(action, locale, categoryLabelKey, values);
    }

    public static String parameterLabel(Object action, Locale locale, String parameterName, Object ... values) {
        String parameterLabelKey = PARAMETER_PREFIX + parameterName + LABEL_SUFFIX;
        return INSTANCE.getMandatoryMessage(action, locale, parameterLabelKey, values);
    }

    public static String parameterDescription(Object action, Locale locale, String parameterName, Object ... values) {
        String parameterDescriptionKey = PARAMETER_PREFIX + parameterName + DESCRIPTION_SUFFIX;
        return INSTANCE.getMandatoryMessage(action, locale, parameterDescriptionKey, values);
    }

    public static String choice(Object action, Locale locale, String choiceName, Object ... values) {
        String choiceKey = CHOICE_PREFIX + choiceName;
        return INSTANCE.getMandatoryMessage(action, locale, choiceKey, values);
    }

    @Override
    public String getString(Locale locale, String code) {
        return this.getMandatoryMessage(null, locale, code, new Object[0]);
    }

    @Override
    public String getString(Locale locale, String code, String defaultMessage) {
        return this.getMandatoryMessage(null, locale, code, new Object[0]);
    }

    @Override
    public String getString(Locale locale, String code, Object ... args) {
        return this.getMandatoryMessage(this, locale, code, args);
    }

    private String formatMessage(String template, Object ... args) {
        MessageFormat messageFormat = new MessageFormat(template);
        return messageFormat.format(args);
    }

    private String getOptionalMessage(Object action, Locale locale, String code, Object ... args) {
        String messageFormat = this.getBundleValue(action, locale, code);
        return messageFormat == null ? null : this.formatMessage(messageFormat, args);
    }

    private String getBundleValue(Object action, Locale locale, String code) {
        CacheKey cacheKey = new CacheKey(action, locale, code);
        String bundleMessage = (String)this.cache.getIfPresent((Object)cacheKey);
        if (bundleMessage == null) {
            ResourceBundle bundle = this.findBundleContainingKey(action, locale, code, this.getBundlesFallbackList(action));
            if (Objects.nonNull(bundle)) {
                bundleMessage = bundle.getString(code);
                this.cache.put((Object)cacheKey, (Object)bundleMessage);
            } else {
                bundleMessage = null;
            }
        }
        return bundleMessage;
    }

    private String getMandatoryMessage(Object action, Locale locale, String code, Object ... args) {
        String message = this.getOptionalMessage(action, locale, code, args);
        if (message == null) {
            throw new TalendRuntimeException((ErrorCode)BaseErrorCodes.MISSING_I18N, ExceptionContext.withBuilder().put("code", (Object)code).put("action", action).build());
        }
        return message;
    }

    private ResourceBundle findBundleContainingKey(Object action, Locale locale, String key, Collection<String> bundleFallbacks) {
        ResourceBundle bundle = null;
        Iterator<String> iterator = bundleFallbacks.iterator();
        while (iterator.hasNext() && bundle == null) {
            String packageName = iterator.next();
            try {
                ResourceBundle searchedBundle = ResourceBundle.getBundle(packageName + '.' + ACTIONS_MESSAGES, locale, ResourceBundle.Control.getNoFallbackControl(ResourceBundle.Control.FORMAT_PROPERTIES));
                if (!searchedBundle.containsKey(key)) continue;
                bundle = searchedBundle;
            }
            catch (MissingResourceException e) {
                LOGGER.debug("No action resource bundle found for action '{}' at '{}'", new Object[]{action, packageName, e});
            }
        }
        return bundle;
    }

    private Collection<String> getBundlesFallbackList(Object action) {
        LinkedHashSet<String> packageHierarchy = new LinkedHashSet<String>();
        if (Objects.nonNull(action)) {
            packageHierarchy.addAll(Arrays.asList(this.getPackageHierarchy(action.getClass())));
        }
        packageHierarchy.addAll(Arrays.asList(this.getPackageHierarchy(this.getClass())));
        packageHierarchy.add(BUNDLE_NAME);
        return packageHierarchy;
    }

    private String[] getPackageHierarchy(Class<?> clazz) {
        String packageName = clazz.getPackage().getName();
        String[] hierarchy = new String[StringUtils.countMatches((CharSequence)packageName, (CharSequence)".") + 1];
        for (int i = 0; i < hierarchy.length; ++i) {
            hierarchy[i] = packageName;
            packageName = StringUtils.substringBeforeLast((String)packageName, (String)".");
        }
        return hierarchy;
    }

    private void setDocumentationUrlBase(String documentationUrlBase) {
        this.documentationUrlBase = documentationUrlBase;
    }

    private String getDocumentationUrlBase() {
        return this.documentationUrlBase;
    }

    private static class CacheKey {
        private final Object action;
        private final Locale locale;
        private final String code;

        private CacheKey(Object action, Locale locale, String code) {
            this.action = action;
            this.locale = locale;
            this.code = code;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CacheKey cacheKey = (CacheKey)o;
            return Objects.equals(this.action, cacheKey.action) && Objects.equals(this.locale, cacheKey.locale) && Objects.equals(this.code, cacheKey.code);
        }

        public int hashCode() {
            return Objects.hash(this.action, this.locale, this.code);
        }
    }
}

