/*
 * Decompiled with CFR 0.152.
 */
package org.talend.dataprep.i18n;

import java.net.URISyntaxException;
import java.util.Locale;
import java.util.Objects;
import org.apache.commons.lang.StringUtils;
import org.apache.http.client.utils.URIBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DocumentationLinkGenerator {
    private static final Logger LOGGER = LoggerFactory.getLogger(DocumentationLinkGenerator.class);
    private static final String AFS_LANGUAGE_PARAMETER = "afs:lang";
    private static final String CONTENT_LANG_PARAMETER = "content-lang";

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String url;
        private Locale locale;
        private boolean addAfsLanguageParameter;
        private boolean addContentLangParameter;

        public Builder url(String url) {
            this.url = url;
            return this;
        }

        public Builder locale(Locale locale) {
            this.locale = locale;
            return this;
        }

        public Builder addAfsLanguageParameter(boolean addAfsLanguageParameter) {
            this.addAfsLanguageParameter = addAfsLanguageParameter;
            return this;
        }

        public Builder addContentLangParameter(boolean addContentLangParameter) {
            this.addContentLangParameter = addContentLangParameter;
            return this;
        }

        public String build() {
            if (StringUtils.isEmpty((String)this.url)) {
                return this.url;
            }
            try {
                URIBuilder urlWithLangParameter = new URIBuilder(this.url);
                if (this.addAfsLanguageParameter && Objects.nonNull(this.locale)) {
                    urlWithLangParameter.addParameter(DocumentationLinkGenerator.AFS_LANGUAGE_PARAMETER, this.locale.getLanguage());
                }
                if (this.addContentLangParameter && Objects.nonNull(this.locale)) {
                    urlWithLangParameter.addParameter(DocumentationLinkGenerator.CONTENT_LANG_PARAMETER, this.locale.getLanguage());
                }
                return urlWithLangParameter.build().toString();
            }
            catch (URISyntaxException e) {
                LOGGER.error("{} is not a valid URL", (Object)this.url, (Object)e);
                return this.url;
            }
        }
    }
}

