/*
 * Decompiled with CFR 0.152.
 */
package org.talend.dataprep.parameters;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.talend.dataprep.parameters.ClusterItem;

public class Clusters {
    private final List<String> titles = new ArrayList<String>(2);
    private final List<ClusterItem> clusterItems = new ArrayList<ClusterItem>();

    private Clusters(List<String> titles, List<ClusterItem> clusters) {
        this.titles.addAll(titles);
        this.clusterItems.addAll(clusters);
    }

    public static Builder builder() {
        return new Builder();
    }

    public List<String> getTitles() {
        return this.titles;
    }

    public List<ClusterItem> getClusters() {
        return this.clusterItems;
    }

    public static class Builder {
        private final List<String> titles = new ArrayList<String>(2);
        private final List<ClusterItem.Builder> clusters = new ArrayList<ClusterItem.Builder>();

        public Builder title(String title) {
            this.titles.add(title);
            return this;
        }

        public Builder cluster(ClusterItem.Builder cluster) {
            this.clusters.add(cluster);
            return this;
        }

        public Clusters build() {
            List items = this.clusters.stream().map(ClusterItem.Builder::build).collect(Collectors.toList());
            return new Clusters(this.titles, items);
        }
    }
}

