/*
 * Decompiled with CFR 0.152.
 */
package org.talend.dataprep.parameters;

import com.fasterxml.jackson.annotation.JsonInclude;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.talend.dataprep.api.preparation.Action;
import org.talend.dataprep.i18n.ActionsBundle;
import org.talend.dataprep.parameters.ParameterType;

public class Parameter
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String name;
    private String type;
    private String defaultValue;
    private boolean implicit;
    private boolean canBeBlank;
    private String placeHolder;
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private Map<String, Object> configuration = new HashMap<String, Object>();
    private String label;
    private String description;
    private Boolean readonly;

    public Parameter() {
    }

    protected Parameter(String name, ParameterType type, String defaultValue, boolean implicit, boolean canBeBlank, String placeHolder, String label, String description, Boolean readonly) {
        this.name = name;
        this.placeHolder = placeHolder;
        this.type = type == null ? null : type.asString();
        this.defaultValue = defaultValue;
        this.implicit = implicit;
        this.canBeBlank = canBeBlank;
        this.label = label;
        this.description = description;
        this.readonly = readonly;
    }

    public static ParameterBuilder parameter(Locale locale) {
        return new ParameterBuilder(locale);
    }

    public static Parameter generateParameter(Locale locale, String name, ParameterType type, String defaultValue, Boolean implicit, Boolean canBeBlank, Action action) {
        return Parameter.parameter(locale).setName(name).setType(type).setDefaultValue(defaultValue).setImplicit(implicit).setCanBeBlank(canBeBlank).build(action);
    }

    void addConfiguration(String name, Object configuration) {
        this.configuration.put(name, configuration);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getDefault() {
        return this.defaultValue;
    }

    public void setDefault(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    public boolean isImplicit() {
        return this.implicit;
    }

    public void setImplicit(boolean implicit) {
        this.implicit = implicit;
    }

    public boolean isCanBeBlank() {
        return this.canBeBlank;
    }

    public void setCanBeBlank(boolean canBeBlank) {
        this.canBeBlank = canBeBlank;
    }

    public String getPlaceHolder() {
        return this.placeHolder;
    }

    public void setPlaceHolder(String placeHolder) {
        this.placeHolder = placeHolder;
    }

    public Map<String, Object> getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(Map<String, Object> configuration) {
        this.configuration = configuration;
    }

    public Boolean isReadonly() {
        return this.readonly;
    }

    public void setReadonly(Boolean readonly) {
        this.readonly = readonly;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Parameter parameter = (Parameter)o;
        return this.implicit == parameter.implicit && this.canBeBlank == parameter.canBeBlank && Objects.equals(this.name, parameter.name) && Objects.equals(this.type, parameter.type) && Objects.equals(this.defaultValue, parameter.defaultValue) && Objects.equals(this.placeHolder, parameter.placeHolder) && Objects.equals(this.configuration, parameter.configuration) && Objects.equals(this.label, parameter.label) && Objects.equals(this.description, parameter.description) && Objects.equals(this.readonly, parameter.readonly);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.type, this.defaultValue, this.implicit, this.canBeBlank, this.placeHolder, this.configuration, this.label, this.description, this.readonly);
    }

    public static class ParameterBuilder {
        private static final Logger LOGGER = LoggerFactory.getLogger(ParameterBuilder.class);
        private String name;
        private ParameterType type;
        private String defaultValue = null;
        private boolean implicit = false;
        private boolean canBeBlank = true;
        private String placeHolder = "";
        private String label;
        private String description;
        private Locale locale;
        private Boolean readonly = null;

        private ParameterBuilder(Locale locale) {
            this.locale = locale;
        }

        public ParameterBuilder setName(String name) {
            this.name = name;
            return this;
        }

        public ParameterBuilder setType(ParameterType type) {
            this.type = type;
            return this;
        }

        public ParameterBuilder setDefaultValue(String defaultValue) {
            this.defaultValue = defaultValue;
            return this;
        }

        public ParameterBuilder setDefaultValue(Boolean defaultValue) {
            this.defaultValue = defaultValue.toString();
            return this;
        }

        public ParameterBuilder setImplicit(boolean implicit) {
            this.implicit = implicit;
            return this;
        }

        public ParameterBuilder setCanBeBlank(boolean canBeBlank) {
            this.canBeBlank = canBeBlank;
            return this;
        }

        public ParameterBuilder setPlaceHolder(String placeHolder) {
            this.placeHolder = placeHolder;
            return this;
        }

        public ParameterBuilder setLabel(String label) {
            this.label = label;
            return this;
        }

        public ParameterBuilder setDescription(String description) {
            this.description = description;
            return this;
        }

        public ParameterBuilder setReadonly(boolean readonly) {
            this.readonly = readonly;
            return this;
        }

        public Parameter build(Object action) {
            if (this.label == null) {
                LOGGER.debug("Warning: implicit label in [{}] parameter creation.", (Object)this.name);
                try {
                    this.label = ActionsBundle.parameterLabel(action, this.locale, this.name, new Object[0]);
                }
                catch (Exception e) {
                    LOGGER.trace("Error while auto-finding label parameter for [{}].", (Object)this.name);
                }
            }
            if (this.description == null) {
                LOGGER.debug("Warning: implicit description in [{}] parameter creation.", (Object)this.name);
                try {
                    this.description = ActionsBundle.parameterDescription(action, this.locale, this.name, new Object[0]);
                }
                catch (Exception e) {
                    LOGGER.trace("Error while auto-finding description parameter for [{}].", (Object)this.name);
                }
            }
            return new Parameter(this.name, this.type, this.defaultValue, this.implicit, this.canBeBlank, this.placeHolder, this.label, this.description, this.readonly);
        }
    }
}

