/*
 * Decompiled with CFR 0.152.
 */
package org.talend.dataprep.parameters;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import org.talend.dataprep.i18n.ActionsBundle;
import org.talend.dataprep.parameters.Item;
import org.talend.dataprep.parameters.Parameter;
import org.talend.dataprep.parameters.ParameterType;

public class SelectParameter
extends Parameter {
    private static final long serialVersionUID = 1L;
    private boolean radio;
    @JsonIgnore
    private List<Item> items;
    @JsonIgnore
    private boolean multiple;

    public SelectParameter() {
    }

    private SelectParameter(String name, String defaultValue, boolean implicit, boolean canBeBlank, List<Item> items, boolean multiple, boolean radio, String label, String description) {
        super(name, ParameterType.SELECT, defaultValue, implicit, canBeBlank, "", label, description, true);
        this.setRadio(radio);
        this.setItems(items);
        this.setMultiple(multiple);
    }

    public boolean getRadio() {
        return this.radio;
    }

    public void setRadio(boolean radio) {
        this.radio = radio;
    }

    public static SelectParameterBuilder selectParameter(Locale locale) {
        return new SelectParameterBuilder(locale);
    }

    public boolean isRadio() {
        return this.radio;
    }

    public List<Item> getItems() {
        return this.items;
    }

    private void setItems(List<Item> items) {
        this.addConfiguration("values", items);
        this.items = items;
    }

    public boolean isMultiple() {
        return this.multiple;
    }

    private void setMultiple(boolean multiple) {
        this.addConfiguration("multiple", multiple);
        this.multiple = multiple;
    }

    public static class SelectParameterBuilder {
        private final List<Item> items = new ArrayList<Item>();
        private final boolean multiple = false;
        private String name = "";
        private String defaultValue = "";
        private boolean implicit;
        private boolean canBeBlank;
        private boolean radio;
        private String label;
        private String description;
        private Locale locale;

        public SelectParameterBuilder(Locale locale) {
            this.locale = locale;
        }

        public SelectParameterBuilder name(String name) {
            this.name = name;
            return this;
        }

        public SelectParameterBuilder defaultValue(String defaultValue) {
            this.defaultValue = defaultValue;
            return this;
        }

        public SelectParameterBuilder implicit(boolean implicit) {
            this.implicit = implicit;
            return this;
        }

        public SelectParameterBuilder canBeBlank(boolean canBeBlank) {
            this.canBeBlank = canBeBlank;
            return this;
        }

        public SelectParameterBuilder item(String value, Parameter ... parameter) {
            this.items.add(new Item(value, value, Arrays.asList(parameter)));
            return this;
        }

        public SelectParameterBuilder item(String value) {
            this.items.add(new Item(value, value, null));
            return this;
        }

        public SelectParameterBuilder item(String value, String labelKey) {
            this.items.add(new Item(value, ActionsBundle.choice(null, this.locale, labelKey, new Object[0]), null));
            return this;
        }

        public SelectParameterBuilder constant(String value, String text) {
            this.items.add(new Item(value, text, null));
            return this;
        }

        public SelectParameterBuilder item(String value, String labelKey, Parameter ... parameter) {
            this.items.add(new Item(value, ActionsBundle.choice(null, this.locale, labelKey, new Object[0]), Arrays.asList(parameter)));
            return this;
        }

        public SelectParameterBuilder items(List<Item> items) {
            this.items.addAll(items);
            return this;
        }

        public SelectParameterBuilder radio(boolean radio) {
            this.radio = radio;
            return this;
        }

        public SelectParameterBuilder setLabel(String label) {
            this.label = label;
            return this;
        }

        public SelectParameterBuilder setDescription(String description) {
            this.description = description;
            return this;
        }

        public SelectParameter build(Object action) {
            if (this.label == null) {
                this.label = ActionsBundle.parameterLabel(action, this.locale, this.name, new Object[0]);
            }
            if (this.description == null) {
                this.description = ActionsBundle.parameterDescription(action, this.locale, this.name, new Object[0]);
            }
            return new SelectParameter(this.name, this.defaultValue, this.implicit, this.canBeBlank, this.items, false, this.radio, this.label, this.description);
        }
    }
}

