/*
 * Decompiled with CFR 0.152.
 */
package org.talend.dataprep.quality;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.talend.dataprep.api.dataset.ColumnMetadata;
import org.talend.dataprep.api.dataset.row.RowMetadataUtils;
import org.talend.dataprep.api.dataset.statistics.date.StreamDateHistogramAnalyzer;
import org.talend.dataprep.api.dataset.statistics.date.StreamDateHistogramStatistics;
import org.talend.dataprep.api.dataset.statistics.number.StreamNumberHistogramAnalyzer;
import org.talend.dataprep.api.type.TypeUtils;
import org.talend.dataprep.transformation.actions.date.DateParser;
import org.talend.dataprep.transformation.api.transformer.json.NullAnalyzer;
import org.talend.dataquality.common.inference.Analyzer;
import org.talend.dataquality.common.inference.Analyzers;
import org.talend.dataquality.common.inference.Metadata;
import org.talend.dataquality.common.inference.QualityAnalyzer;
import org.talend.dataquality.common.inference.ValueQualityStatistics;
import org.talend.dataquality.semantic.classifier.SemanticCategoryEnum;
import org.talend.dataquality.semantic.snapshot.DictionarySnapshot;
import org.talend.dataquality.semantic.snapshot.DictionarySnapshotProvider;
import org.talend.dataquality.semantic.snapshot.StandardDictionarySnapshotProvider;
import org.talend.dataquality.semantic.statistics.SemanticAnalyzer;
import org.talend.dataquality.semantic.statistics.SemanticQualityAnalyzer;
import org.talend.dataquality.semantic.statistics.SemanticType;
import org.talend.dataquality.statistics.cardinality.CardinalityAnalyzer;
import org.talend.dataquality.statistics.cardinality.CardinalityStatistics;
import org.talend.dataquality.statistics.frequency.AbstractFrequencyAnalyzer;
import org.talend.dataquality.statistics.frequency.DataTypeFrequencyAnalyzer;
import org.talend.dataquality.statistics.frequency.DataTypeFrequencyStatistics;
import org.talend.dataquality.statistics.frequency.pattern.CompositePatternFrequencyAnalyzer;
import org.talend.dataquality.statistics.frequency.pattern.PatternFrequencyStatistics;
import org.talend.dataquality.statistics.frequency.recognition.DateTimePatternRecognizer;
import org.talend.dataquality.statistics.frequency.recognition.EmptyPatternRecognizer;
import org.talend.dataquality.statistics.frequency.recognition.LatinExtendedCharPatternRecognizer;
import org.talend.dataquality.statistics.numeric.quantile.QuantileAnalyzer;
import org.talend.dataquality.statistics.numeric.quantile.QuantileStatistics;
import org.talend.dataquality.statistics.numeric.summary.SummaryAnalyzer;
import org.talend.dataquality.statistics.numeric.summary.SummaryStatistics;
import org.talend.dataquality.statistics.quality.DataTypeQualityAnalyzer;
import org.talend.dataquality.statistics.quality.ValueQualityAnalyzer;
import org.talend.dataquality.statistics.text.TextLengthAnalyzer;
import org.talend.dataquality.statistics.text.TextLengthStatistics;
import org.talend.dataquality.statistics.type.DataTypeAnalyzer;
import org.talend.dataquality.statistics.type.DataTypeEnum;
import org.talend.dataquality.statistics.type.DataTypeOccurences;

public class AnalyzerService {
    private static final Logger LOGGER = LoggerFactory.getLogger(AnalyzerService.class);
    private final DateParser dateParser;
    private final Set<Analyzer> openedAnalyzers = new HashSet<Analyzer>();
    private DictionarySnapshotProvider dictionarySnapshotProvider;

    public AnalyzerService() {
        this((DictionarySnapshotProvider)new StandardDictionarySnapshotProvider());
    }

    public AnalyzerService(DictionarySnapshotProvider dictionarySnapshotProvider) {
        this.dictionarySnapshotProvider = dictionarySnapshotProvider;
        this.dateParser = new DateParser(this);
    }

    public void setDictionarySnapshotProvider(DictionarySnapshotProvider provider) {
        this.dictionarySnapshotProvider = provider;
    }

    private static AbstractFrequencyAnalyzer buildPatternAnalyzer(List<ColumnMetadata> columns) {
        DateTimePatternRecognizer dateTimePatternFrequencyAnalyzer = new DateTimePatternRecognizer();
        ArrayList<String> patterns = new ArrayList<String>(columns.size());
        for (ColumnMetadata column : columns) {
            String pattern = RowMetadataUtils.getMostUsedDatePattern(column);
            if (!StringUtils.isNotBlank((String)pattern)) continue;
            patterns.add(pattern);
        }
        dateTimePatternFrequencyAnalyzer.addCustomDateTimePatterns(patterns);
        ArrayList<Object> patternFrequencyAnalyzers = new ArrayList<Object>();
        patternFrequencyAnalyzers.add(new EmptyPatternRecognizer());
        patternFrequencyAnalyzers.add(dateTimePatternFrequencyAnalyzer);
        patternFrequencyAnalyzers.add(new LatinExtendedCharPatternRecognizer());
        return new CompositePatternFrequencyAnalyzer(patternFrequencyAnalyzers, TypeUtils.convert(columns));
    }

    private List<String> getMostUsedDatePatterns(List<ColumnMetadata> columns) {
        ArrayList<String> patterns = new ArrayList<String>(columns.size());
        for (ColumnMetadata column : columns) {
            String pattern = RowMetadataUtils.getMostUsedDatePattern(column);
            if (!StringUtils.isNotBlank((String)pattern)) continue;
            patterns.add(pattern);
        }
        return patterns;
    }

    public Analyzer<Analyzers.Result> build(ColumnMetadata column, Analysis ... settings) {
        if (column == null) {
            return this.build(Collections.emptyList(), settings);
        }
        return this.build(Collections.singletonList(column), settings);
    }

    private List<String> extractColumnNames(List<ColumnMetadata> columns) {
        return columns.stream().map(ColumnMetadata::getName).collect(Collectors.toList());
    }

    public Analyzer<Analyzers.Result> build(List<ColumnMetadata> columns, Analysis ... settings) {
        if (columns == null || columns.isEmpty()) {
            return Analyzers.with((Analyzer[])new Analyzer[]{NullAnalyzer.INSTANCE});
        }
        EnumSet<Analysis> all = EnumSet.noneOf(Analysis.class);
        for (Analysis setting : settings) {
            if (setting == null) continue;
            all.add(setting);
            all.addAll(Arrays.asList(setting.dependencies));
        }
        if (all.isEmpty()) {
            return Analyzers.with((Analyzer[])new Analyzer[]{NullAnalyzer.INSTANCE});
        }
        DataTypeEnum[] types = TypeUtils.convert(columns);
        List<String> domainList = columns.stream().map(ColumnMetadata::getDomain).map(d -> StringUtils.isBlank((String)d) ? SemanticCategoryEnum.UNKNOWN.getId() : d).collect(Collectors.toList());
        String[] domains = domainList.toArray(new String[domainList.size()]);
        DictionarySnapshot dictionarySnapshot = this.dictionarySnapshotProvider.get();
        ArrayList<Object> analyzers = new ArrayList<Object>();
        block13: for (Analysis setting : settings) {
            switch (setting) {
                case SEMANTIC: {
                    SemanticAnalyzer semanticAnalyzer = new SemanticAnalyzer(dictionarySnapshot);
                    semanticAnalyzer.setLimit(Integer.MAX_VALUE);
                    semanticAnalyzer.setMetadata(Metadata.HEADER_NAME, this.extractColumnNames(columns));
                    analyzers.add(semanticAnalyzer);
                    continue block13;
                }
                case HISTOGRAM: {
                    analyzers.add(new StreamDateHistogramAnalyzer(columns, types, this.dateParser));
                    analyzers.add((Object)new StreamNumberHistogramAnalyzer(types));
                    continue block13;
                }
                case QUALITY: {
                    DataTypeQualityAnalyzer dataTypeQualityAnalyzer = new DataTypeQualityAnalyzer(types);
                    columns.forEach(c -> dataTypeQualityAnalyzer.addCustomDateTimePattern(RowMetadataUtils.getMostUsedDatePattern(c)));
                    analyzers.add(new ValueQualityAnalyzer((QualityAnalyzer)dataTypeQualityAnalyzer, (QualityAnalyzer)new SemanticQualityAnalyzer(dictionarySnapshot, domains, false), true));
                    continue block13;
                }
                case CARDINALITY: {
                    analyzers.add(new CardinalityAnalyzer());
                    continue block13;
                }
                case PATTERNS: {
                    analyzers.add(AnalyzerService.buildPatternAnalyzer(columns));
                    continue block13;
                }
                case LENGTH: {
                    analyzers.add(new TextLengthAnalyzer());
                    continue block13;
                }
                case QUANTILES: {
                    boolean acceptQuantiles = false;
                    for (DataTypeEnum type : types) {
                        if (type != DataTypeEnum.INTEGER && type != DataTypeEnum.DOUBLE) continue;
                        acceptQuantiles = true;
                        break;
                    }
                    if (!acceptQuantiles) continue block13;
                    analyzers.add(new QuantileAnalyzer(types));
                    continue block13;
                }
                case SUMMARY: {
                    analyzers.add(new SummaryAnalyzer(types));
                    continue block13;
                }
                case TYPE: {
                    boolean shouldUseTypeAnalysis = true;
                    for (Analysis analysis : settings) {
                        if (analysis != Analysis.QUALITY) continue;
                        shouldUseTypeAnalysis = false;
                        break;
                    }
                    if (shouldUseTypeAnalysis) {
                        List<String> mostUsedDatePatterns = this.getMostUsedDatePatterns(columns);
                        analyzers.add(new DataTypeAnalyzer(mostUsedDatePatterns));
                        continue block13;
                    }
                    LOGGER.warn("Disabled {} analysis (conflicts with {}).", (Object)setting, (Object)Analysis.QUALITY);
                    continue block13;
                }
                case FREQUENCY: {
                    analyzers.add(new DataTypeFrequencyAnalyzer());
                    continue block13;
                }
                default: {
                    throw new IllegalArgumentException("Missing support for '" + (Object)((Object)setting) + "'.");
                }
            }
        }
        Analyzer analyzer = Analyzers.with((Analyzer[])analyzers.toArray(new Analyzer[analyzers.size()]));
        analyzer.init();
        if (LOGGER.isDebugEnabled()) {
            return new ResourceMonitoredAnalyzer(analyzer);
        }
        return analyzer;
    }

    public Analyzer<Analyzers.Result> full(List<ColumnMetadata> columns) {
        return this.build(columns, Analysis.QUALITY, Analysis.CARDINALITY, Analysis.FREQUENCY, Analysis.PATTERNS, Analysis.LENGTH, Analysis.SEMANTIC, Analysis.QUANTILES, Analysis.SUMMARY, Analysis.HISTOGRAM);
    }

    public Analyzer<Analyzers.Result> qualityAnalysis(List<ColumnMetadata> columns) {
        return this.build(columns, Analysis.QUALITY, Analysis.SUMMARY, Analysis.SEMANTIC);
    }

    public Analyzer<Analyzers.Result> schemaAnalysis(List<ColumnMetadata> columns) {
        return this.build(columns, Analysis.SEMANTIC, Analysis.TYPE);
    }

    private class ResourceMonitoredAnalyzer
    implements Analyzer<Analyzers.Result> {
        private final Analyzer<Analyzers.Result> analyzer;
        private final Exception caller = new RuntimeException();
        private long lastCall;

        private ResourceMonitoredAnalyzer(Analyzer<Analyzers.Result> analyzer) {
            AnalyzerService.this.openedAnalyzers.add(this);
            this.analyzer = analyzer;
        }

        public void init() {
            this.analyzer.init();
        }

        public boolean analyze(String ... strings) {
            this.lastCall = System.currentTimeMillis();
            return this.analyzer.analyze(strings);
        }

        public void end() {
            this.analyzer.end();
        }

        public List<Analyzers.Result> getResult() {
            return this.analyzer.getResult();
        }

        public Analyzer<Analyzers.Result> merge(Analyzer<Analyzers.Result> analyzer) {
            return analyzer.merge(analyzer);
        }

        public void close() throws Exception {
            this.analyzer.close();
            AnalyzerService.this.openedAnalyzers.remove(this);
        }

        public String toString() {
            StringBuilder toStringBuilder = new StringBuilder();
            toStringBuilder.append(this.analyzer.toString()).append(' ').append(" last used (").append(System.currentTimeMillis() - this.lastCall).append(" ms ago) ");
            StringWriter toStringCaller = new StringWriter();
            this.caller.printStackTrace(new PrintWriter(toStringCaller));
            toStringBuilder.append("caller: ").append(toStringCaller.toString());
            return toStringBuilder.toString();
        }
    }

    public static enum Analysis {
        TYPE(DataTypeOccurences.class, new Analysis[0]),
        SEMANTIC(SemanticType.class, new Analysis[0]),
        HISTOGRAM(StreamDateHistogramStatistics.class, new Analysis[0]),
        QUALITY(ValueQualityStatistics.class, new Analysis[0]),
        CARDINALITY(CardinalityStatistics.class, new Analysis[0]),
        PATTERNS(PatternFrequencyStatistics.class, new Analysis[0]),
        LENGTH(TextLengthStatistics.class, new Analysis[0]),
        QUANTILES(QuantileStatistics.class, new Analysis[0]),
        SUMMARY(SummaryStatistics.class, new Analysis[0]),
        FREQUENCY(DataTypeFrequencyStatistics.class, new Analysis[0]);

        private final Class resultClass;
        private final Analysis[] dependencies;

        private Analysis(Class resultClass, Analysis ... dependencies) {
            this.resultClass = resultClass;
            this.dependencies = dependencies;
        }

        public Class getResultClass() {
            return this.resultClass;
        }
    }
}

