/*
 * Decompiled with CFR 0.152.
 */
package org.talend.dataprep.schema;

import java.io.IOException;
import java.io.InputStream;
import org.apache.tika.io.TemporaryResources;
import org.apache.tika.io.TikaInputStream;
import org.apache.tika.metadata.Metadata;
import org.talend.dataprep.schema.Format;

@FunctionalInterface
public interface Detector {
    public Format detect(Metadata var1, TikaInputStream var2) throws IOException;

    default public Format detect(InputStream inputStream) throws IOException {
        if (inputStream == null) {
            throw new IllegalArgumentException("The specified input stream for a format detection must not be null!");
        }
        TemporaryResources tmp = new TemporaryResources();
        try (TikaInputStream tis = TikaInputStream.get((InputStream)inputStream, (TemporaryResources)tmp);){
            Format format = this.detect(new Metadata(), tis);
            return format;
        }
    }
}

