/*
 * Decompiled with CFR 0.152.
 */
package org.talend.dataprep.schema;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.talend.dataprep.api.dataset.ColumnMetadata;

public class Schema
implements Serializable {
    private static final long serialVersionUID = 1L;
    @JsonProperty(value="draft")
    private boolean draft;
    @JsonProperty(value="sheetContents")
    private List<SheetContent> sheetContents;
    @JsonProperty(value="sheetName")
    private String sheetName;

    private Schema(boolean draft, List<SheetContent> sheetContents, String sheetName) {
        this.draft = draft;
        this.sheetContents = sheetContents;
        this.sheetName = sheetName;
    }

    private Schema() {
    }

    public boolean draft() {
        return this.draft;
    }

    public List<SheetContent> getSheetContents() {
        return this.sheetContents;
    }

    public String getSheetName() {
        return this.sheetName;
    }

    public String toString() {
        return "SchemaParserResult{draft=" + this.draft + ", sheetContents=" + this.sheetContents + ", sheetName='" + this.sheetName + '\'' + '}';
    }

    public static class Builder {
        private boolean draft;
        private List<SheetContent> sheetContents;
        private String sheetName;

        public static Builder parserResult() {
            return new Builder();
        }

        public Builder draft(boolean draft) {
            this.draft = draft;
            return this;
        }

        public Builder sheetContents(List<SheetContent> sheetContents) {
            if (sheetContents == null) {
                return this;
            }
            this.sheetContents = new ArrayList<SheetContent>();
            this.sheetContents.addAll(sheetContents.stream().map(SheetContent::clone).collect(Collectors.toList()));
            return this;
        }

        public Builder sheetName(String sheetName) {
            this.sheetName = sheetName;
            return this;
        }

        public Builder copy(Schema original) {
            this.draft = original.draft();
            this.sheetContents = original.getSheetContents();
            this.sheetName = original.getSheetName();
            return this;
        }

        public Schema build() {
            return new Schema(this.draft, this.sheetContents, this.sheetName);
        }
    }

    public static class SheetContent
    implements Serializable {
        private static final long serialVersionUID = 1L;
        @JsonProperty(value="name")
        private String name;
        @JsonProperty(value="columnMetadatas")
        private List<ColumnMetadata> columnMetadatas;

        public SheetContent() {
        }

        public SheetContent(String name, List<ColumnMetadata> columnMetadatas) {
            this.name = name;
            this.columnMetadatas = columnMetadatas;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public List<ColumnMetadata> getColumnMetadatas() {
            return this.columnMetadatas;
        }

        public void setColumnMetadatas(List<ColumnMetadata> columnMetadatas) {
            this.columnMetadatas = columnMetadatas;
        }

        public SheetContent clone() {
            ArrayList<ColumnMetadata> columns = null;
            if (this.columnMetadatas != null) {
                columns = new ArrayList<ColumnMetadata>();
                for (ColumnMetadata column : this.columnMetadatas) {
                    columns.add(ColumnMetadata.Builder.column().copy(column).build());
                }
            }
            return new SheetContent(this.name, columns);
        }

        public String toString() {
            return "SheetContent{name='" + this.name + '\'' + ", columnMetadatas=" + this.columnMetadatas + '}';
        }
    }
}

