/*
 * Decompiled with CFR 0.152.
 */
package org.talend.dataprep.transformation.actions;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.talend.dataprep.transformation.actions.PrototypeScope;
import org.talend.dataprep.transformation.actions.date.DateParser;

public class Providers {
    public static final SingletonProvider DEFAULT_PROVIDER = new SingletonProvider(new InstantiationProvider());
    private static final Logger LOGGER = LoggerFactory.getLogger(Providers.class);
    private static Provider provider = DEFAULT_PROVIDER;

    public static void setProvider(Provider newProvider) {
        LOGGER.info("Change action component provider from '{}' to '{}'.", (Object)provider, (Object)newProvider);
        provider = newProvider;
    }

    public static <T> T get(Class<T> clazz) {
        return Providers.get(clazz, new Object[0]);
    }

    public static <T> T get(Class<T> clazz, Object ... args) {
        return provider.get(clazz, args);
    }

    public static DateParser get() {
        return provider.get(DateParser.class, new Object[0]);
    }

    public static void clear() {
        provider.clear();
    }

    private static class InstantiationProvider
    implements Provider {
        private static final Object lock = new Object();

        InstantiationProvider() {
        }

        @Override
        public <T> T get(Class<T> clazz, Object ... args) {
            List<Class> argsClasses = Stream.of(args).map(Object::getClass).collect(Collectors.toList());
            if (clazz.isInterface()) {
                Object object = lock;
                synchronized (object) {
                    try {
                        Reflections reflections = new Reflections(clazz.getPackage().getName(), new Scanner[0]);
                        Set subTypesOf = reflections.getSubTypesOf(clazz);
                        LOGGER.debug("Found these sub types of " + clazz.getName() + ": {}", (Object)subTypesOf);
                        Constructor constructor = null;
                        for (Class subType : subTypesOf) {
                            try {
                                constructor = subType.getConstructor(argsClasses.toArray(new Class[argsClasses.size()]));
                                constructor.setAccessible(true);
                            }
                            catch (NoSuchMethodException e) {
                                LOGGER.debug("Skip class '{}' (no constructor with arguments '{}')", clazz, (Object)args);
                            }
                        }
                        if (constructor == null) {
                            throw new IllegalArgumentException("No implementation of '" + clazz.getName() + "' with constructor '" + Arrays.toString(args) + "' found.");
                        }
                        if (argsClasses.isEmpty()) {
                            return clazz.cast(constructor.newInstance(new Object[0]));
                        }
                        return clazz.cast(constructor.newInstance(args));
                    }
                    catch (Exception e) {
                        throw new UnsupportedOperationException("Unable to instantiate a sub type of interface'" + clazz.getName() + "' with args: '" + Arrays.toString(args) + "'.", e);
                    }
                }
            }
            try {
                if (argsClasses.isEmpty()) {
                    return clazz.newInstance();
                }
                return clazz.getConstructor(argsClasses.toArray(new Class[argsClasses.size()])).newInstance(args);
            }
            catch (Exception e) {
                throw new UnsupportedOperationException("Unable to instantiate '" + clazz.getName() + "'.", e);
            }
        }

        @Override
        public void clear() {
        }
    }

    private static class SingletonProvider
    implements Provider {
        private final Provider next;
        private final Map<Class, Object> singletons = new HashMap<Class, Object>();

        SingletonProvider(Provider next) {
            this.next = next;
        }

        @Override
        public <T> T get(Class<T> clazz, Object ... args) {
            Object o;
            if (this.singletons.containsKey(clazz)) {
                o = this.singletons.get(clazz);
            } else {
                T newValue = this.next.get(clazz, args);
                Annotation[] annotations = newValue.getClass().getDeclaredAnnotations();
                if (Arrays.stream(annotations).anyMatch(a -> a instanceof PrototypeScope)) {
                    o = this.next.get(clazz, args);
                } else {
                    this.singletons.put(clazz, newValue);
                    o = newValue;
                }
            }
            return clazz.cast(o);
        }

        @Override
        public void clear() {
            this.singletons.clear();
        }
    }

    public static interface Provider {
        public <T> T get(Class<T> var1, Object ... var2);

        public void clear();
    }
}

