/*
 * Decompiled with CFR 0.152.
 */
package org.talend.dataprep.transformation.actions.category;

import java.util.Map;
import java.util.function.Predicate;
import org.talend.dataprep.transformation.actions.common.ImplicitParameters;

public enum ScopeCategory {
    CELL(ImplicitParameters.ROW_ID, ImplicitParameters.COLUMN_ID),
    COLUMN(ImplicitParameters.COLUMN_ID),
    LINE(ImplicitParameters.ROW_ID),
    DATASET(new ImplicitParameters[0]);

    private final Predicate<Map<String, String>> mandatoryParametersChecker = map -> {
        for (ImplicitParameters param : mandatoryParameters) {
            if (map.containsKey(param.getKey())) continue;
            return false;
        }
        return true;
    };

    private ScopeCategory(ImplicitParameters ... mandatoryParameters) {
    }

    public static ScopeCategory from(String scopeAsString) {
        if (scopeAsString == null) {
            return null;
        }
        return ScopeCategory.valueOf(scopeAsString.toUpperCase());
    }

    public boolean checkMandatoryParameters(Map<String, String> parameters) {
        return this.mandatoryParametersChecker.test(parameters);
    }
}

