/*
 * Decompiled with CFR 0.152.
 */
package org.talend.dataprep.transformation.actions.common;

import java.util.HashMap;
import java.util.Map;
import org.talend.dataprep.api.action.ActionDefinition;
import org.talend.dataprep.transformation.actions.category.ScopeCategory;
import org.talend.dataprep.transformation.actions.common.ApplyDataSetRowAction;
import org.talend.dataprep.transformation.actions.common.CompileDataSetRowAction;
import org.talend.dataprep.transformation.actions.common.ImplicitParameters;
import org.talend.dataprep.transformation.actions.common.RunnableAction;
import org.talend.dataprep.transformation.api.action.validation.ActionMetadataValidation;

public class ActionFactory {
    private final ActionMetadataValidation validator = new ActionMetadataValidation();

    private ScopeCategory getScope(Map<String, String> parameters) {
        return ScopeCategory.from(parameters.get(ImplicitParameters.SCOPE.getKey()));
    }

    public final RunnableAction create(ActionDefinition actionDefinition, Map<String, String> parameters) {
        if (parameters == null) {
            throw new IllegalArgumentException("Parameters cannot be null.");
        }
        this.validator.checkScopeConsistency(actionDefinition, parameters);
        HashMap<String, String> parametersCopy = new HashMap<String, String>(parameters);
        ScopeCategory scope = this.getScope(parametersCopy);
        actionDefinition = actionDefinition.adapt(scope);
        return RunnableAction.Builder.builder().withName(actionDefinition.getName()).withParameters(parametersCopy).withCompile(new CompileDataSetRowAction(parametersCopy, actionDefinition, scope)).withRow(new ApplyDataSetRowAction(actionDefinition, parameters, scope)).build();
    }
}

