/*
 * Decompiled with CFR 0.152.
 */
package org.talend.dataprep.transformation.actions.common;

import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.talend.dataprep.api.action.ActionDefinition;
import org.talend.dataprep.api.dataset.row.DataSetRow;
import org.talend.dataprep.transformation.actions.category.ScopeCategory;
import org.talend.dataprep.transformation.actions.common.CellAction;
import org.talend.dataprep.transformation.actions.common.ColumnAction;
import org.talend.dataprep.transformation.actions.common.DataSetAction;
import org.talend.dataprep.transformation.actions.common.RowAction;
import org.talend.dataprep.transformation.api.action.DataSetRowAction;
import org.talend.dataprep.transformation.api.action.context.ActionContext;

public class ApplyDataSetRowAction
implements DataSetRowAction {
    private static final Logger LOGGER = LoggerFactory.getLogger(ApplyDataSetRowAction.class);
    private final ActionDefinition metadata;
    private final Map<String, String> parameters;
    private final ScopeCategory scope;

    public ApplyDataSetRowAction(ActionDefinition metadata, Map<String, String> parameters, ScopeCategory scope) {
        this.metadata = metadata;
        this.parameters = parameters;
        this.scope = scope;
    }

    @Override
    public DataSetRow apply(DataSetRow dataSetRow, ActionContext context) {
        return this.handleRow(this.metadata, this.parameters, this.scope, dataSetRow, context);
    }

    private DataSetRow handleRow(ActionDefinition metadata, Map<String, String> parameters, ScopeCategory scope, DataSetRow row, ActionContext context) {
        try {
            boolean implicitFilter = metadata.implicitFilter();
            DataSetRow actionRow = implicitFilter && !context.getFilter().test(row) ? row.unmodifiable() : row;
            switch (scope) {
                case CELL: {
                    ((CellAction)((Object)metadata)).applyOnCell(actionRow, context);
                    break;
                }
                case LINE: {
                    ((RowAction)((Object)metadata)).applyOnLine(actionRow, context);
                    break;
                }
                case COLUMN: {
                    ((ColumnAction)((Object)metadata)).applyOnColumn(actionRow, context);
                    break;
                }
                case DATASET: {
                    ((DataSetAction)((Object)metadata)).applyOnDataSet(actionRow, context);
                    break;
                }
                default: {
                    LOGGER.warn("Is there a new action scope ??? {}", (Object)scope);
                }
            }
            return actionRow.modifiable();
        }
        catch (Throwable e) {
            LOGGER.error("Unable to use action '{}' (parameters: {}) due to unexpected error.", new Object[]{metadata.getName(), parameters, e});
            context.setActionStatus(ActionContext.ActionStatus.CANCELED);
            return row.modifiable();
        }
    }
}

