/*
 * Decompiled with CFR 0.152.
 */
package org.talend.dataprep.transformation.actions.common;

import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.talend.dataprep.api.action.ActionDefinition;
import org.talend.dataprep.api.dataset.RowMetadata;
import org.talend.dataprep.api.dataset.row.DataSetRow;
import org.talend.dataprep.api.filter.FilterService;
import org.talend.dataprep.api.filter.PolyglotFilterService;
import org.talend.dataprep.transformation.actions.Providers;
import org.talend.dataprep.transformation.actions.category.ScopeCategory;
import org.talend.dataprep.transformation.actions.common.ImplicitParameters;
import org.talend.dataprep.transformation.api.action.DataSetRowAction;
import org.talend.dataprep.transformation.api.action.context.ActionContext;

public class CompileDataSetRowAction
implements DataSetRowAction {
    private static final Logger LOGGER = LoggerFactory.getLogger(CompileDataSetRowAction.class);
    private final Map<String, String> parametersCopy;
    private final ActionDefinition metadata;
    private final ScopeCategory scope;

    public CompileDataSetRowAction(Map<String, String> parametersCopy, ActionDefinition metadata, ScopeCategory scope) {
        this.parametersCopy = parametersCopy;
        this.metadata = metadata;
        this.scope = scope;
    }

    @Override
    public DataSetRow apply(DataSetRow dataSetRow, ActionContext context) {
        return dataSetRow;
    }

    @Override
    public void compile(ActionContext actionContext) {
        try {
            actionContext.setParameters(this.parametersCopy);
            this.metadata.compile(actionContext);
            actionContext.setFilter(this.getFilter(this.parametersCopy, actionContext.getRowMetadata()));
        }
        catch (Exception e) {
            LOGGER.error("Unable to use action '{}' due to unexpected error.", (Object)this.metadata.getName(), (Object)e);
            actionContext.setActionStatus(ActionContext.ActionStatus.CANCELED);
        }
    }

    private Predicate<DataSetRow> getFilter(Map<String, String> parameters, RowMetadata rowMetadata) {
        String filterAsString = parameters.get(ImplicitParameters.FILTER.getKey());
        Predicate<DataSetRow> predicate = this.getFilterService().build(filterAsString, rowMetadata);
        if (this.scope == ScopeCategory.CELL || this.scope == ScopeCategory.LINE) {
            String rowIdAsString = parameters.get(ImplicitParameters.ROW_ID.getKey());
            Long rowId = StringUtils.isNotBlank((String)rowIdAsString) ? Long.valueOf(Long.parseLong(rowIdAsString)) : null;
            Predicate<DataSetRow> rowFilter = r -> Objects.equals(r.getTdpId(), rowId);
            return predicate.and(rowFilter);
        }
        return predicate;
    }

    private FilterService getFilterService() {
        return Providers.get(PolyglotFilterService.class);
    }
}

