/*
 * Decompiled with CFR 0.152.
 */
package org.talend.dataprep.transformation.actions.common;

import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import org.talend.dataprep.i18n.ActionsBundle;
import org.talend.dataprep.parameters.Parameter;
import org.talend.dataprep.parameters.ParameterType;

public enum ImplicitParameters {
    COLUMN_ID(ParameterType.STRING, ""),
    ROW_ID(ParameterType.STRING, ""),
    SCOPE(ParameterType.STRING, ""),
    FILTER(ParameterType.FILTER, "");

    private final ParameterType type;
    private final String defaultValue;

    private ImplicitParameters(ParameterType type, String defaultValue) {
        this.type = type;
        this.defaultValue = defaultValue;
    }

    public static List<Parameter> getParameters(Locale locale) {
        return Arrays.stream(ImplicitParameters.values()).map(ip -> ip.getParameter(locale)).collect(Collectors.toList());
    }

    public String getKey() {
        return this.name().toLowerCase();
    }

    public Parameter getParameter(Locale locale) {
        return Parameter.parameter(locale).setName(this.name().toLowerCase()).setType(this.type).setDefaultValue(this.defaultValue).setImplicit(true).setLabel(ActionsBundle.parameterLabel(null, locale, this.name().toLowerCase(), new Object[0])).setDescription(ActionsBundle.parameterDescription(null, locale, this.name().toLowerCase(), new Object[0])).build((Object)this);
    }
}

