/*
 * Decompiled with CFR 0.152.
 */
package org.talend.dataprep.transformation.actions.date;

import java.time.DateTimeException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.talend.dataprep.api.dataset.ColumnMetadata;
import org.talend.dataprep.api.dataset.statistics.PatternFrequency;
import org.talend.dataprep.quality.AnalyzerService;
import org.talend.dataprep.transformation.actions.Providers;
import org.talend.dataprep.transformation.actions.date.DatePattern;
import org.talend.dataquality.common.inference.Analyzer;
import org.talend.dataquality.common.inference.Analyzers;
import org.talend.dataquality.statistics.datetime.SystemDateTimePatternManager;
import org.talend.dataquality.statistics.frequency.pattern.PatternFrequencyStatistics;

public class DateParser {
    private static final Logger LOGGER = LoggerFactory.getLogger(DateParser.class);
    private final AnalyzerService analyzerService;

    public DateParser() {
        this(Providers.get(AnalyzerService.class));
    }

    public DateParser(AnalyzerService analyzerService) {
        this.analyzerService = analyzerService;
    }

    public LocalDateTime parse(String value, ColumnMetadata column) {
        try {
            return this.parseDateFromPatterns(value, this.getPatterns(column.getStatistics().getPatternFrequencies()));
        }
        catch (DateTimeException e) {
            LOGGER.debug("Unable to parse date '{}'", (Object)value, (Object)e);
            return this.guessAndParse(value, column);
        }
    }

    LocalDateTime guessAndParse(String value, ColumnMetadata column) {
        DatePattern guessedPattern = this.guessPattern(value, column);
        LocalDateTime result = this.parseDateFromPatterns(value, Collections.singletonList(guessedPattern));
        List<PatternFrequency> patternFrequencies = column.getStatistics().getPatternFrequencies();
        patternFrequencies.add(new PatternFrequency(guessedPattern.getPattern(), guessedPattern.getOccurrences()));
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    DatePattern guessPattern(String value, ColumnMetadata column) {
        if (StringUtils.isEmpty((String)value)) {
            throw new DateTimeException("No pattern can be found out of '" + value + "'");
        }
        try (Analyzer<Analyzers.Result> analyzer = this.analyzerService.build(column, AnalyzerService.Analysis.PATTERNS);){
            analyzer.analyze(new String[]{value});
            analyzer.end();
            Analyzers.Result result = (Analyzers.Result)analyzer.getResult().get(0);
            if (result.exist(PatternFrequencyStatistics.class)) {
                PatternFrequencyStatistics patternFrequencyStatistics = (PatternFrequencyStatistics)result.get(PatternFrequencyStatistics.class);
                Map topTerms = patternFrequencyStatistics.getTopK(1);
                ArrayList<PatternFrequency> patterns = new ArrayList<PatternFrequency>(1);
                topTerms.forEach((s, o) -> patterns.add(new PatternFrequency((String)s, (long)o)));
                List<DatePattern> results = this.getPatterns(patterns);
                if (results.isEmpty()) {
                    throw new DateTimeException("DQ did not find any pattern for '" + value + "'");
                }
                DatePattern datePattern = this.getPatterns(patterns).get(0);
                return datePattern;
            }
            throw new DateTimeException("DQ did not find any pattern for '" + value + "'");
        }
        catch (Exception e) {
            throw new DateTimeException("Unable to close analyzer after analyzing value '" + value + "'", e);
        }
    }

    public LocalDateTime parseDateFromPatterns(String value, List<DatePattern> patterns) {
        if (value == null) {
            throw new DateTimeException("cannot parse null");
        }
        for (DatePattern pattern : patterns) {
            DateTimeFormatter formatter = SystemDateTimePatternManager.getDateTimeFormatterByPattern((String)pattern.getPattern(), (Locale)Locale.ENGLISH);
            if (formatter == null) continue;
            try {
                return LocalDateTime.parse(value, formatter);
            }
            catch (DateTimeException e) {
                LOGGER.trace("Unable to parse date '{}' using LocalDateTime.", (Object)value, (Object)e);
                try {
                    LocalDate temp = LocalDate.parse(value, formatter);
                    return temp.atStartOfDay();
                }
                catch (DateTimeException e2) {
                    LOGGER.trace("Unable to parse date '{}' using LocalDate.", (Object)value, (Object)e2);
                }
            }
        }
        throw new DateTimeException("'" + value + "' does not match any known pattern");
    }

    public List<DatePattern> getPatterns(List<PatternFrequency> patternsFrequency) {
        HashSet distinctPatterns = new HashSet(patternsFrequency.size());
        return patternsFrequency.stream().filter(patternFreqItem -> StringUtils.isNotEmpty((String)patternFreqItem.getPattern())).filter(patternFreqItem -> distinctPatterns.add(patternFreqItem.getPattern())).map(patternFreqItem -> {
            try {
                return new DatePattern(patternFreqItem.getPattern(), patternFreqItem.getOccurrences());
            }
            catch (IllegalArgumentException e) {
                LOGGER.debug("Unable to parse pattern '{}'", (Object)patternFreqItem.getPattern(), (Object)e);
                return null;
            }
        }).filter(Objects::nonNull).sorted().collect(Collectors.toList());
    }
}

