/*
 * Decompiled with CFR 0.152.
 */
package org.talend.dataprep.transformation.actions.date;

import java.time.format.DateTimeFormatter;
import java.util.Locale;
import java.util.Objects;

public class DatePattern
implements Comparable {
    private long occurrences;
    private final String pattern;
    private final DateTimeFormatter formatter;

    public DatePattern(String pattern) {
        this.pattern = pattern;
        this.formatter = DateTimeFormatter.ofPattern(pattern, Locale.ENGLISH);
    }

    public DatePattern(String pattern, long occurrences) {
        this(pattern);
        this.occurrences = occurrences;
    }

    public long getOccurrences() {
        return this.occurrences;
    }

    public String getPattern() {
        return this.pattern;
    }

    public DateTimeFormatter getFormatter() {
        return this.formatter;
    }

    public int compareTo(Object o) {
        DatePattern other = (DatePattern)o;
        if (this.equals(other)) {
            return 0;
        }
        if (other.getOccurrences() == this.getOccurrences()) {
            return 1;
        }
        return Long.compare(other.getOccurrences(), this.getOccurrences());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DatePattern that = (DatePattern)o;
        return Objects.equals(this.occurrences, that.occurrences) && Objects.equals(this.pattern, that.pattern);
    }

    public int hashCode() {
        return Objects.hash(this.occurrences, this.pattern);
    }

    public String toString() {
        return "DatePattern{occurrences=" + this.occurrences + ", pattern='" + this.pattern + '\'' + '}';
    }
}

