/*
 * Decompiled with CFR 0.152.
 */
package org.talend.dataprep.transformation.api.action;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.talend.daikon.exception.TalendRuntimeException;
import org.talend.daikon.exception.error.ErrorCode;
import org.talend.dataprep.BaseErrorCodes;
import org.talend.dataprep.api.action.ActionDefinition;
import org.talend.dataprep.api.preparation.Action;
import org.talend.dataprep.api.preparation.Actions;
import org.talend.dataprep.transformation.actions.common.ActionFactory;
import org.talend.dataprep.transformation.actions.common.RunnableAction;
import org.talend.dataprep.transformation.pipeline.ActionRegistry;

public class ActionParser {
    private final ActionFactory factory;
    private final ActionRegistry actionRegistry;
    private final ObjectMapper mapper;

    public ActionParser(ActionFactory factory, ActionRegistry actionRegistry, ObjectMapper mapper) {
        this.factory = factory;
        this.actionRegistry = actionRegistry;
        this.mapper = mapper;
    }

    public List<RunnableAction> parse(String actions) {
        if (actions == null) {
            throw new IllegalArgumentException("Actions parameter can not be null.");
        }
        if (StringUtils.isEmpty((String)actions)) {
            return Collections.emptyList();
        }
        try {
            Actions parsedActions = (Actions)this.mapper.reader(Actions.class).readValue(actions);
            List<Action> allActions = parsedActions.getActions();
            ArrayList<RunnableAction> builtActions = new ArrayList<RunnableAction>(allActions.size() + 1);
            allActions.stream().filter(parsedAction -> parsedAction != null && parsedAction.getName() != null).forEach(parsedAction -> {
                String actionNameLowerCase = parsedAction.getName().toLowerCase();
                ActionDefinition metadata = this.actionRegistry.get(actionNameLowerCase);
                builtActions.add(this.factory.create(metadata, parsedAction.getParameters()));
            });
            return builtActions;
        }
        catch (TalendRuntimeException tpe) {
            throw tpe;
        }
        catch (Exception e) {
            throw new TalendRuntimeException((ErrorCode)BaseErrorCodes.UNABLE_TO_PARSE_JSON, (Throwable)e);
        }
    }
}

