/*
 * Decompiled with CFR 0.152.
 */
package org.talend.dataprep.transformation.api.action.context;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.talend.dataprep.api.dataset.ColumnMetadata;
import org.talend.dataprep.api.dataset.RowMetadata;
import org.talend.dataprep.api.dataset.row.DataSetRow;
import org.talend.dataprep.transformation.actions.category.ScopeCategory;
import org.talend.dataprep.transformation.actions.common.ImplicitParameters;
import org.talend.dataprep.transformation.api.action.context.TransformationContext;

public class ActionContext
implements Serializable {
    private static final Logger LOGGER = LoggerFactory.getLogger(ActionContext.class);
    private static final String COLUMN_CONTEXT_PREFIX = "col#";
    private final TransformationContext parent;
    private transient Map<String, Object> context = new HashMap<String, Object>();
    private RowMetadata rowMetadata;
    private Map<String, String> parameters = Collections.emptyMap();
    private ActionStatus actionStatus = ActionStatus.NOT_EXECUTED;
    private transient Predicate<DataSetRow> filter = r -> true;

    public ActionContext(TransformationContext parent) {
        this(parent, new RowMetadata());
    }

    public ActionContext(TransformationContext parent, RowMetadata rowMetadata) {
        this.parent = parent;
        this.rowMetadata = rowMetadata;
    }

    public Predicate<DataSetRow> getFilter() {
        return this.filter == null ? r -> true : this.filter;
    }

    public void setFilter(Predicate<DataSetRow> filter) {
        this.filter = filter;
    }

    public TransformationContext getParent() {
        return this.parent;
    }

    public String column(String name, Function<RowMetadata, ColumnMetadata> create) {
        String key = this.getColumnKey(name);
        if (this.getContext().containsKey(key)) {
            return ((ColumnMetadata)this.getContext().get(key)).getId();
        }
        ColumnMetadata columnMetadata = create.apply(this.rowMetadata);
        if (columnMetadata == null) {
            throw new IllegalArgumentException("Cannot use a null column for '" + name + "'");
        }
        this.getContext().put(key, columnMetadata);
        return columnMetadata.getId();
    }

    public String column(String name) {
        String key = this.getColumnKey(name);
        if (this.getContext().containsKey(key)) {
            return ((ColumnMetadata)this.getContext().get(key)).getId();
        }
        throw new IllegalArgumentException("Column '" + name + "' does not exist in action.");
    }

    String getColumnKey(String name) {
        return COLUMN_CONTEXT_PREFIX + name;
    }

    public boolean has(String key) {
        return this.getContext().containsKey(key);
    }

    public <T> T get(String key) {
        if (this.getContext().containsKey(key)) {
            return (T)this.getContext().get(key);
        }
        throw new IllegalArgumentException("Key '" + key + "' does not exist.");
    }

    public boolean contains(String key) {
        return this.getContext().containsKey(key);
    }

    public <T> T get(String key, Function<Map<String, String>, T> supplier) {
        Object value = this.getContext().get(key);
        if (value == null) {
            value = supplier.apply(this.parameters);
            this.getContext().put(key, value);
            LOGGER.debug("adding {}->{} in this context {}", new Object[]{key, value, this});
        }
        return (T)value;
    }

    public void evict(String key) {
        this.getContext().remove(key);
    }

    public Collection<Object> getContextEntries() {
        return this.getContext().values();
    }

    public ActionContext asImmutable() {
        return new ImmutableActionContext(this);
    }

    public RowMetadata getRowMetadata() {
        return this.rowMetadata;
    }

    public void setRowMetadata(RowMetadata rowMetadata) {
        this.rowMetadata = rowMetadata;
        List<String> toRemove = this.getContext().keySet().stream().filter(s -> s.startsWith(COLUMN_CONTEXT_PREFIX)).collect(Collectors.toList());
        toRemove.forEach(this.getContext()::remove);
        LOGGER.debug("Removed {} when new row was set.", toRemove);
    }

    private Map<String, Object> getContext() {
        if (this.context == null) {
            this.context = new HashMap<String, Object>();
        }
        return this.context;
    }

    public void setParameters(Map<String, String> parameters) {
        this.parameters = parameters;
    }

    public String getColumnId() {
        return this.parameters.get(ImplicitParameters.COLUMN_ID.getKey());
    }

    public String getColumnName() {
        return this.getRowMetadata().getById(this.getColumnId()).getName();
    }

    public Map<String, String> getParameters() {
        return this.parameters;
    }

    public Long getRowId() {
        return Long.parseLong(this.parameters.get(ImplicitParameters.ROW_ID.getKey()));
    }

    public ScopeCategory getScope() {
        String scopeParameter = this.parameters.get(ImplicitParameters.SCOPE.getKey());
        if (scopeParameter != null) {
            return ScopeCategory.valueOf(scopeParameter.toUpperCase());
        }
        return null;
    }

    public ActionStatus getActionStatus() {
        return this.actionStatus;
    }

    public void setActionStatus(ActionStatus actionStatus) {
        if (this.actionStatus == ActionStatus.CANCELED && actionStatus == ActionStatus.OK) {
            return;
        }
        if (this.actionStatus != actionStatus && actionStatus == ActionStatus.DONE) {
            this.parent.freezeActionContext(this);
        }
        this.actionStatus = actionStatus;
    }

    public String toString() {
        return "ActionContext{parent=#" + this.parent + ", context=" + this.getContext() + ", parameters=" + this.parameters + ", actionStatus=" + (Object)((Object)this.actionStatus) + '}';
    }

    private static class ImmutableActionContext
    extends ActionContext {
        private final ActionContext delegate;

        private ImmutableActionContext(ActionContext delegate) {
            super(delegate.parent, delegate.getRowMetadata());
            this.delegate = delegate;
        }

        @Override
        public void setRowMetadata(RowMetadata rowMetadata) {
        }

        @Override
        public void setParameters(Map<String, String> parameters) {
        }

        @Override
        public String getColumnId() {
            return this.delegate.getColumnId();
        }

        @Override
        public Map<String, String> getParameters() {
            return Collections.unmodifiableMap(this.delegate.getParameters());
        }

        @Override
        public Long getRowId() {
            return this.delegate.getRowId();
        }

        @Override
        public ScopeCategory getScope() {
            return this.delegate.getScope();
        }

        @Override
        public ActionStatus getActionStatus() {
            return this.delegate.getActionStatus();
        }

        @Override
        public void setActionStatus(ActionStatus actionStatus) {
            this.delegate.setActionStatus(actionStatus);
        }

        @Override
        public TransformationContext getParent() {
            return this.delegate.getParent();
        }

        @Override
        public String column(String name, Function<RowMetadata, ColumnMetadata> create) {
            if (!this.delegate.getContext().containsKey(this.getColumnKey(name))) {
                throw new UnsupportedOperationException();
            }
            return this.delegate.column(name, create);
        }

        @Override
        public <T> T get(String key) {
            return this.delegate.get(key);
        }

        @Override
        public void evict(String key) {
        }

        @Override
        public <T> T get(String key, Function<Map<String, String>, T> supplier) {
            return this.delegate.get(key, supplier);
        }

        @Override
        public Collection<Object> getContextEntries() {
            return Collections.unmodifiableCollection(this.delegate.getContextEntries());
        }

        @Override
        public ActionContext asImmutable() {
            return this;
        }

        @Override
        public RowMetadata getRowMetadata() {
            return this.delegate.getRowMetadata();
        }
    }

    public static enum ActionStatus {
        NOT_EXECUTED,
        OK,
        DONE,
        CANCELED;

    }
}

