/*
 * Decompiled with CFR 0.152.
 */
package org.talend.dataprep.transformation.api.action.context;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.ClassUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.talend.dataprep.api.dataset.RowMetadata;
import org.talend.dataprep.transformation.api.action.DataSetRowAction;
import org.talend.dataprep.transformation.api.action.context.ActionContext;

public final class TransformationContext
implements Serializable {
    private static final Logger LOGGER = LoggerFactory.getLogger(TransformationContext.class);
    private final transient Map<DataSetRowAction, ActionContext> contexts;
    private final transient Map<String, Object> context = new HashMap<String, Object>();

    public TransformationContext() {
        this.contexts = new HashMap<DataSetRowAction, ActionContext>();
    }

    public void put(String key, Object value) {
        this.context.put(key, value);
        LOGGER.debug("adding {}->{} to the context", (Object)key, value);
    }

    public Object get(String key) {
        return this.context.get(key);
    }

    private Collection<ActionContext> getAllActionsContexts() {
        return this.contexts.values();
    }

    public void freezeActionContext(ActionContext actionContext) {
        this.contexts.replaceAll((action, ac) -> {
            if (ac == actionContext) {
                return actionContext.asImmutable();
            }
            return ac;
        });
    }

    public void cleanup() {
        Collection<ActionContext> allActionsContexts = this.getAllActionsContexts();
        LOGGER.debug("cleaning up {} action context(s) ", (Object)allActionsContexts.size());
        for (ActionContext currentContext : allActionsContexts) {
            currentContext.getContextEntries().forEach(contextEntry -> {
                try {
                    try {
                        Method destroy = ClassUtils.getPublicMethod(contextEntry.getClass(), (String)"destroy", (Class[])new Class[0]);
                        LOGGER.debug("destroy {}", contextEntry);
                        destroy.invoke(contextEntry, new Object[0]);
                    }
                    catch (NoSuchMethodException e) {
                        LOGGER.trace("Context entry {} does not need clean up.", contextEntry, (Object)e);
                    }
                }
                catch (Exception error) {
                    LOGGER.warn("error cleaning action context {}", contextEntry, (Object)error);
                }
            });
        }
    }

    public ActionContext create(DataSetRowAction action, RowMetadata rowMetadata) {
        if (this.contexts.containsKey(action)) {
            return this.contexts.get(action);
        }
        ActionContext actionContext = new ActionContext(this, rowMetadata);
        this.contexts.put(action, actionContext);
        LOGGER.debug("adding new ActionContext for {}", (Object)action);
        return actionContext;
    }

    public ActionContext in(DataSetRowAction action) {
        if (this.contexts.containsKey(action)) {
            return this.contexts.get(action);
        }
        throw new IllegalStateException("No action context found for '" + action + "'.");
    }
}

