/*
 * Decompiled with CFR 0.152.
 */
package org.talend.dataprep.transformation.pipeline;

import org.talend.dataprep.transformation.pipeline.Monitored;
import org.talend.dataprep.transformation.pipeline.Node;
import org.talend.dataprep.transformation.pipeline.Pipeline;
import org.talend.dataprep.transformation.pipeline.Visitor;
import org.talend.dataprep.transformation.pipeline.link.BasicLink;
import org.talend.dataprep.transformation.pipeline.link.CloneLink;
import org.talend.dataprep.transformation.pipeline.node.ActionNode;
import org.talend.dataprep.transformation.pipeline.node.CompileNode;
import org.talend.dataprep.transformation.pipeline.node.SourceNode;
import org.talend.dataprep.transformation.pipeline.node.StepNode;

public class PipelineConsoleDump
extends Visitor {
    private final StringBuilder builder;

    public PipelineConsoleDump(StringBuilder builder) {
        this.builder = builder;
    }

    private void buildMonitorInformation(Monitored monitored) {
        long totalTime = monitored.getTotalTime();
        long count = monitored.getCount();
        double speed = totalTime > 0L ? (double)Math.round((double)count * 1000.0 / (double)totalTime) : Double.POSITIVE_INFINITY;
        this.builder.append("(").append(monitored.getTotalTime()).append(" ms - ").append(monitored.getCount()).append(" rows - ").append(speed).append(" rows/s) ");
    }

    @Override
    public void visitAction(ActionNode actionNode) {
        this.buildMonitorInformation(actionNode);
        this.builder.append("ACTION").append(" [").append(actionNode.getAction().getName()).append("] ").append("(status: ").append((Object)actionNode.getActionContext().getActionStatus()).append(")").append('\n');
        super.visitAction(actionNode);
    }

    @Override
    public void visitCompile(CompileNode compileNode) {
        this.builder.append("COMPILE").append(" [").append(compileNode.getAction().getName()).append("] ").append("(status: ").append((Object)compileNode.getActionContext().getActionStatus()).append(")").append('\n');
        super.visitCompile(compileNode);
    }

    @Override
    public void visitSource(SourceNode sourceNode) {
        this.builder.append("-> SOURCE").append('\n');
        super.visitSource(sourceNode);
    }

    @Override
    public void visitBasicLink(BasicLink basicLink) {
        this.builder.append("-> ");
        super.visitBasicLink(basicLink);
    }

    @Override
    public void visitPipeline(Pipeline pipeline) {
        this.builder.append("PIPELINE {").append('\n');
        super.visitPipeline(pipeline);
        this.builder.append('\n').append('}').append('\n');
    }

    @Override
    public void visitNode(Node node) {
        if (node instanceof Monitored) {
            this.buildMonitorInformation((Monitored)((Object)node));
        }
        this.builder.append("UNKNOWN NODE (").append(node.getClass().getName()).append(")").append('\n');
        super.visitNode(node);
    }

    @Override
    public void visitCloneLink(CloneLink cloneLink) {
        this.builder.append("->").append('\n');
        super.visitCloneLink(cloneLink);
    }

    @Override
    public void visitStepNode(StepNode stepNode) {
        this.builder.append("STEP NODE (").append(stepNode.getStep().toString()).append(")\n");
        super.visitStepNode(stepNode);
    }
}

