/*
 * Decompiled with CFR 0.152.
 */
package org.talend.dataprep.transformation.pipeline;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.talend.dataprep.api.dataset.RowMetadata;
import org.talend.dataprep.api.preparation.Step;
import org.talend.dataprep.transformation.pipeline.Node;
import org.talend.dataprep.transformation.pipeline.Visitor;
import org.talend.dataprep.transformation.pipeline.builder.NodeBuilder;
import org.talend.dataprep.transformation.pipeline.link.BasicLink;
import org.talend.dataprep.transformation.pipeline.node.ActionNode;
import org.talend.dataprep.transformation.pipeline.node.CompileNode;
import org.talend.dataprep.transformation.pipeline.node.SourceNode;
import org.talend.dataprep.transformation.pipeline.node.StepNode;

class StepNodeTransformation
extends Visitor {
    private static final Logger LOGGER = LoggerFactory.getLogger(StepNodeTransformation.class);
    private final Iterator<Step> steps;
    private final Function<Step, RowMetadata> previousStepRowMetadataSupplier;
    private State DISPATCH = new Dispatch();
    private State DEFAULT = new DefaultState();
    private State state = this.DISPATCH;
    private NodeBuilder builder = NodeBuilder.source();

    StepNodeTransformation(List<Step> steps, Function<Step, RowMetadata> previousStepRowMetadataSupplier) {
        if (!steps.isEmpty() && !Step.ROOT_STEP.getId().equals(steps.get(0).getId())) {
            Collections.reverse(steps);
        }
        this.steps = steps.iterator();
        this.previousStepRowMetadataSupplier = previousStepRowMetadataSupplier;
    }

    Node getTransformedNode() {
        if (this.steps.hasNext()) {
            AtomicInteger remainingCount = new AtomicInteger(0);
            this.steps.forEachRemaining(s -> {
                if (!Step.ROOT_STEP.getId().equals(s.getId())) {
                    LOGGER.warn("Remaining step #{}: {}", (Object)remainingCount.get(), s);
                    remainingCount.incrementAndGet();
                }
            });
            if (remainingCount.get() > 0) {
                LOGGER.warn("Too many steps remaining ({} remaining).", (Object)remainingCount.get());
            }
        }
        return this.builder.build();
    }

    private void processNode(Node node) {
        this.state = this.state.process(node);
    }

    @Override
    public void visitAction(ActionNode actionNode) {
        this.processNode(actionNode);
        super.visitAction(actionNode);
    }

    @Override
    public void visitCompile(CompileNode compileNode) {
        this.processNode(compileNode);
        super.visitCompile(compileNode);
    }

    @Override
    public void visitNode(Node node) {
        this.processNode(node);
        super.visitNode(node);
    }

    private class DefaultState
    implements State {
        private DefaultState() {
        }

        @Override
        public State process(Node node) {
            StepNodeTransformation.this.builder.to(node.copyShallow());
            return StepNodeTransformation.this.DISPATCH;
        }
    }

    private class StepState
    implements State {
        private final Node previous;
        private final Step step;

        private StepState(Node previous, Step step) {
            this.previous = previous;
            this.step = step;
        }

        @Override
        public State process(Node node) {
            if (node instanceof CompileNode) {
                NodeCopy copy = new NodeCopy();
                node.accept(copy);
                StepNode stepNode = new StepNode(this.step, (RowMetadata)StepNodeTransformation.this.previousStepRowMetadataSupplier.apply(this.step), copy.getCopy(), copy.getLastNode());
                Optional.ofNullable(this.previous).ifPresent(n -> n.setLink(new BasicLink(stepNode)));
                StepNodeTransformation.this.builder.to(stepNode);
                return this;
            }
            if (node instanceof ActionNode) {
                return StepNodeTransformation.this.DISPATCH;
            }
            return this;
        }

        class NodeCopy
        extends Visitor {
            private final NodeBuilder builder = NodeBuilder.source();
            private boolean hasEnded = false;
            private Node lastNode;

            NodeCopy() {
            }

            @Override
            public void visitAction(ActionNode actionNode) {
                if (!this.hasEnded) {
                    this.lastNode = actionNode.copyShallow();
                    this.builder.to(this.lastNode);
                    this.hasEnded = true;
                }
            }

            @Override
            public void visitCompile(CompileNode compileNode) {
                this.visitNode(compileNode);
                super.visitCompile(compileNode);
            }

            @Override
            public void visitSource(SourceNode sourceNode) {
                this.visitNode(sourceNode);
                super.visitSource(sourceNode);
            }

            @Override
            public void visitStepNode(StepNode stepNode) {
                this.visitNode(stepNode);
                super.visitStepNode(stepNode);
            }

            @Override
            public void visitNode(Node node) {
                this.builder.to(node.copyShallow());
                super.visitNode(node);
            }

            public Node getCopy() {
                return this.builder.build();
            }

            public Node getLastNode() {
                return this.lastNode;
            }
        }
    }

    private class Dispatch
    implements State {
        private Node previous = null;

        private Dispatch() {
        }

        @Override
        public State process(Node node) {
            State newState;
            if (node instanceof CompileNode) {
                if (!StepNodeTransformation.this.steps.hasNext()) {
                    throw new IllegalArgumentException("Not enough steps to transform pipeline.");
                }
                Step nextStep = (Step)StepNodeTransformation.this.steps.next();
                if (Step.ROOT_STEP.getId().equals(nextStep.getId())) {
                    LOGGER.debug("Unable to use step '{}' (root step).", (Object)nextStep.getId());
                    if (StepNodeTransformation.this.steps.hasNext()) {
                        nextStep = (Step)StepNodeTransformation.this.steps.next();
                    } else {
                        LOGGER.error("Unable to use root step as first step and no remaining steps.");
                        nextStep = null;
                    }
                }
                if (nextStep != null) {
                    Optional.ofNullable(this.previous).ifPresent(n -> n.setLink(null));
                    newState = new StepState(this.previous, nextStep);
                } else {
                    newState = StepNodeTransformation.this.DEFAULT;
                }
            } else {
                newState = StepNodeTransformation.this.DEFAULT;
            }
            this.previous = node;
            return newState.process(node);
        }
    }

    static interface State {
        public State process(Node var1);
    }
}

