/*
 * Decompiled with CFR 0.152.
 */
package org.talend.dataprep.transformation.pipeline;

import org.talend.dataprep.transformation.pipeline.Node;
import org.talend.dataprep.transformation.pipeline.Pipeline;
import org.talend.dataprep.transformation.pipeline.link.BasicLink;
import org.talend.dataprep.transformation.pipeline.link.CloneLink;
import org.talend.dataprep.transformation.pipeline.node.ActionNode;
import org.talend.dataprep.transformation.pipeline.node.CompileNode;
import org.talend.dataprep.transformation.pipeline.node.SourceNode;
import org.talend.dataprep.transformation.pipeline.node.StepNode;

public abstract class Visitor {
    private void doNodeVisit(Node node) {
        if (node != null && node.getLink() != null) {
            node.getLink().accept(this);
        }
    }

    public void visitAction(ActionNode actionNode) {
        this.doNodeVisit(actionNode);
    }

    public void visitCompile(CompileNode compileNode) {
        this.doNodeVisit(compileNode);
    }

    public void visitSource(SourceNode sourceNode) {
        this.doNodeVisit(sourceNode);
    }

    public void visitBasicLink(BasicLink basicLink) {
        basicLink.getTarget().accept(this);
    }

    public void visitPipeline(Pipeline pipeline) {
        pipeline.getNode().accept(this);
    }

    public void visitStepNode(StepNode stepNode) {
        this.doNodeVisit(stepNode);
    }

    public void visitNode(Node node) {
        this.doNodeVisit(node);
    }

    public void visitCloneLink(CloneLink cloneLink) {
        Node[] nodes;
        for (Node node : nodes = cloneLink.getNodes()) {
            node.accept(this);
        }
    }
}

