/*
 * Decompiled with CFR 0.152.
 */
package org.talend.dataprep.transformation.pipeline.builder;

import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.talend.dataprep.api.dataset.RowMetadata;
import org.talend.dataprep.dataset.StatisticsAdapter;
import org.talend.dataprep.quality.AnalyzerService;
import org.talend.dataprep.transformation.actions.common.RunnableAction;
import org.talend.dataprep.transformation.api.action.DataSetRowAction;
import org.talend.dataprep.transformation.api.action.context.TransformationContext;
import org.talend.dataprep.transformation.pipeline.ActionRegistry;
import org.talend.dataprep.transformation.pipeline.Node;
import org.talend.dataprep.transformation.pipeline.builder.NodeBuilder;
import org.talend.dataprep.transformation.pipeline.builder.StatisticsNodesBuilder;
import org.talend.dataprep.transformation.pipeline.node.ActionNode;
import org.talend.dataprep.transformation.pipeline.node.CleanUpNode;
import org.talend.dataprep.transformation.pipeline.node.CompileNode;

public class ActionNodesBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger(ActionNodesBuilder.class);
    private RowMetadata initialMetadata;
    private final List<RunnableAction> actions = new ArrayList<RunnableAction>();
    private boolean needStatisticsBefore = false;
    private boolean needStatisticsAfter = false;
    private boolean allowSchemaAnalysis = true;
    private ActionRegistry actionRegistry;
    private StatisticsAdapter statisticsAdapter;
    private AnalyzerService analyzerService;

    public static ActionNodesBuilder builder() {
        return new ActionNodesBuilder();
    }

    public ActionNodesBuilder initialMetadata(RowMetadata initialMetadata) {
        this.initialMetadata = initialMetadata;
        return this;
    }

    public ActionNodesBuilder actions(List<RunnableAction> actions) {
        this.actions.addAll(actions);
        return this;
    }

    public ActionNodesBuilder needStatisticsBefore(boolean needStatisticsBefore) {
        this.needStatisticsBefore = needStatisticsBefore;
        return this;
    }

    public ActionNodesBuilder needStatisticsAfter(boolean needStatisticsAfter) {
        this.needStatisticsAfter = needStatisticsAfter;
        return this;
    }

    public ActionNodesBuilder allowSchemaAnalysis(boolean allowSchemaAnalysis) {
        this.allowSchemaAnalysis = allowSchemaAnalysis;
        return this;
    }

    public ActionNodesBuilder actionRegistry(ActionRegistry actionRegistry) {
        this.actionRegistry = actionRegistry;
        return this;
    }

    public ActionNodesBuilder analyzerService(AnalyzerService analyzerService) {
        this.analyzerService = analyzerService;
        return this;
    }

    public ActionNodesBuilder statisticsAdapter(StatisticsAdapter statisticsAdapter) {
        this.statisticsAdapter = statisticsAdapter;
        return this;
    }

    public Node build() {
        StatisticsNodesBuilder statisticsNodesBuilder = StatisticsNodesBuilder.builder().analyzerService(this.analyzerService).actionRegistry(this.actionRegistry).statisticsAdapter(this.statisticsAdapter).allowSchemaAnalysis(this.allowSchemaAnalysis).actions(this.actions).columns(this.initialMetadata.getColumns());
        NodeBuilder builder = NodeBuilder.source();
        if (this.needStatisticsBefore || this.initialMetadata.getColumns().isEmpty()) {
            LOGGER.debug("No initial metadata submitted for transformation, computing new one.");
            builder.to(statisticsNodesBuilder.buildPreStatistics());
        }
        TransformationContext context = new TransformationContext();
        for (RunnableAction nextAction : this.actions) {
            Node neededReservoir = statisticsNodesBuilder.buildIntermediateStatistics(nextAction);
            if (neededReservoir != null) {
                builder.to(neededReservoir);
            }
            DataSetRowAction rowAction = nextAction.getRowAction();
            builder.to(new CompileNode(nextAction, context.create(rowAction, this.initialMetadata)));
            builder.to(new ActionNode(nextAction, context.in(rowAction)));
        }
        if (this.needStatisticsAfter) {
            builder.to(statisticsNodesBuilder.buildPostStatistics());
        }
        builder.to(new CleanUpNode(context));
        return builder.build();
    }
}

