/*
 * Decompiled with CFR 0.152.
 */
package org.talend.dataprep.transformation.pipeline.builder;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.talend.dataprep.api.action.ActionDefinition;
import org.talend.dataprep.api.dataset.ColumnMetadata;
import org.talend.dataprep.api.preparation.Action;
import org.talend.dataprep.parameters.Parameter;
import org.talend.dataprep.parameters.ParameterType;
import org.talend.dataprep.transformation.actions.category.ScopeCategory;
import org.talend.dataprep.transformation.actions.common.ImplicitParameters;
import org.talend.dataprep.transformation.actions.common.RunnableAction;
import org.talend.dataprep.transformation.pipeline.ActionRegistry;
import org.talend.dataprep.transformation.pipeline.builder.ActionsProfile;
import org.talend.dataprep.transformation.pipeline.builder.SerializablePredicate;

class ActionsStaticProfiler {
    private final ActionRegistry actionRegistry;
    public static final String CREATE_NEW_COLUMN = "create_new_column";

    public ActionsStaticProfiler(ActionRegistry actionRegistry) {
        this.actionRegistry = actionRegistry;
    }

    private Map<Action, ActionDefinition> getActionMetadataByAction(List<RunnableAction> actions) {
        HashMap<Action, ActionDefinition> actionToMetadata = new HashMap<Action, ActionDefinition>(actions.size());
        for (Action action : actions) {
            ActionDefinition actionMetadata = this.actionRegistry.get(action.getName()).adapt(ScopeCategory.from(action.getParameters().get(ImplicitParameters.SCOPE.getKey())));
            actionToMetadata.put(action, actionMetadata);
        }
        return actionToMetadata;
    }

    public ActionsProfile profile(List<ColumnMetadata> columns, List<RunnableAction> actions) {
        Map<Action, ActionDefinition> metadataByAction = this.getActionMetadataByAction(actions);
        Set originalColumns = columns.stream().map(ColumnMetadata::getId).collect(Collectors.toSet());
        HashSet<Object> valueModifiedColumns = new HashSet<Object>();
        HashSet<String> metadataModifiedColumns = new HashSet<String>();
        int createColumnActions = 0;
        for (Map.Entry<Action, ActionDefinition> entry : metadataByAction.entrySet()) {
            ActionDefinition actionMetadata = entry.getValue();
            Action action = entry.getKey();
            Set<ActionDefinition.Behavior> behavior = actionMetadata.getBehavior();
            boolean createColumn = false;
            for (ActionDefinition.Behavior currentBehavior : behavior) {
                switch (currentBehavior) {
                    case VALUES_ALL: {
                        valueModifiedColumns.addAll(originalColumns);
                        break;
                    }
                    case METADATA_CHANGE_TYPE: {
                        valueModifiedColumns.add(action.getParameters().get(ImplicitParameters.COLUMN_ID.getKey()));
                        metadataModifiedColumns.add(action.getParameters().get(ImplicitParameters.COLUMN_ID.getKey()));
                        break;
                    }
                    case VALUES_COLUMN: {
                        valueModifiedColumns.add(action.getParameters().get(ImplicitParameters.COLUMN_ID.getKey()));
                        break;
                    }
                    case VALUES_MULTIPLE_COLUMNS: {
                        valueModifiedColumns.add(action.getParameters().get(ImplicitParameters.COLUMN_ID.getKey()));
                        List<Parameter> parameters = actionMetadata.getParameters(Locale.US);
                        valueModifiedColumns.addAll(parameters.stream().filter(parameter -> ParameterType.valueOf(parameter.getType().toUpperCase()) == ParameterType.COLUMN).map(parameter -> action.getParameters().get(parameter.getName())).collect(Collectors.toList()));
                        break;
                    }
                    case METADATA_COPY_COLUMNS: 
                    case METADATA_CREATE_COLUMNS: {
                        createColumn = true;
                        break;
                    }
                    case METADATA_DELETE_COLUMNS: 
                    case METADATA_CHANGE_NAME: {
                        break;
                    }
                }
            }
            if (!createColumn && !ActionsStaticProfiler.isCreateColumnParameterOn(action)) continue;
            ++createColumnActions;
        }
        boolean needFullAnalysis = !valueModifiedColumns.isEmpty() || createColumnActions > 0;
        boolean needOnlyInvalidAnalysis = !needFullAnalysis && !metadataModifiedColumns.isEmpty();
        FilterForFullAnalysis filterForFullAnalysis = new FilterForFullAnalysis(originalColumns, valueModifiedColumns);
        FilterForInvalidAnalysis filterForInvalidAnalysis = new FilterForInvalidAnalysis(filterForFullAnalysis, metadataModifiedColumns);
        return new ActionsProfile(needFullAnalysis, needOnlyInvalidAnalysis, filterForFullAnalysis, filterForInvalidAnalysis, filterForInvalidAnalysis, metadataByAction);
    }

    private static boolean isCreateColumnParameterOn(Action action) {
        return action.getParameters().entrySet().stream().anyMatch(e -> Objects.equals(e.getKey(), CREATE_NEW_COLUMN) && Boolean.parseBoolean((String)e.getValue()));
    }

    private static class FilterForInvalidAnalysis
    implements SerializablePredicate<ColumnMetadata> {
        private static final long serialVersionUID = 1L;
        private final SerializablePredicate<ColumnMetadata> filterForFullAnalysis;
        private final Set<String> metadataModifiedColumns;

        private FilterForInvalidAnalysis(SerializablePredicate<ColumnMetadata> filterForFullAnalysis, Set<String> metadataModifiedColumns) {
            this.filterForFullAnalysis = filterForFullAnalysis;
            this.metadataModifiedColumns = metadataModifiedColumns;
        }

        @Override
        public boolean test(ColumnMetadata columnMetadata) {
            return this.filterForFullAnalysis.test(columnMetadata) || this.metadataModifiedColumns.contains(columnMetadata.getId());
        }
    }

    private static class FilterForFullAnalysis
    implements SerializablePredicate<ColumnMetadata> {
        private static final long serialVersionUID = 1L;
        private final Set<String> originalColumns;
        private final Set<String> valueModifiedColumns;

        private FilterForFullAnalysis(Set<String> originalColumns, Set<String> valueModifiedColumns) {
            this.originalColumns = originalColumns;
            this.valueModifiedColumns = valueModifiedColumns;
        }

        @Override
        public boolean test(ColumnMetadata columnMetadata) {
            return this.valueModifiedColumns.contains(columnMetadata.getId()) || !this.originalColumns.contains(columnMetadata.getId());
        }
    }
}

