/*
 * Decompiled with CFR 0.152.
 */
package org.talend.dataprep.transformation.pipeline.builder;

import java.util.Arrays;
import java.util.function.Function;
import java.util.function.Predicate;
import org.talend.daikon.exception.TalendRuntimeException;
import org.talend.daikon.exception.error.ErrorCode;
import org.talend.dataprep.BaseErrorCodes;
import org.talend.dataprep.api.dataset.row.DataSetRow;
import org.talend.dataprep.transformation.pipeline.Link;
import org.talend.dataprep.transformation.pipeline.Node;
import org.talend.dataprep.transformation.pipeline.link.BasicLink;
import org.talend.dataprep.transformation.pipeline.link.CloneLink;
import org.talend.dataprep.transformation.pipeline.node.FilteredSourceNode;
import org.talend.dataprep.transformation.pipeline.node.SourceNode;
import org.talend.dataprep.transformation.pipeline.node.ZipLink;

public class NodeBuilder {
    private final Node sourceNode;
    private State state;

    private NodeBuilder(Node sourceNode) {
        this.sourceNode = sourceNode;
        this.state = new NodeState(new Node[]{sourceNode});
    }

    public static NodeBuilder source() {
        return new NodeBuilder(new SourceNode());
    }

    public static NodeBuilder from(Node node) {
        return new NodeBuilder(node);
    }

    public static NodeBuilder filteredSource(Predicate<DataSetRow> filter) {
        return new NodeBuilder(new FilteredSourceNode(filter));
    }

    public NodeBuilder to(Node node) {
        Function<Node[], Link> linkFunction = n -> new BasicLink(n[0]);
        return this.to(linkFunction, node);
    }

    public NodeBuilder to(Function<Node[], Link> linkFunction, Node node) {
        try {
            this.state = this.state.next(linkFunction);
            this.state = this.state.next(node);
        }
        catch (IllegalStateException e) {
            throw new TalendRuntimeException((ErrorCode)BaseErrorCodes.UNEXPECTED_EXCEPTION, (Throwable)new Exception("Each to() must be followed by node().", e));
        }
        return this;
    }

    public NodeBuilder dispatchTo(Node ... nodes) {
        if (nodes == null || nodes.length == 0) {
            throw new TalendRuntimeException((ErrorCode)BaseErrorCodes.UNEXPECTED_EXCEPTION, (Throwable)new IllegalArgumentException("Each dispatchTo() must be followed by nodes()."));
        }
        this.state = this.state.next(CloneLink::new);
        this.state = this.state.next(nodes);
        return this;
    }

    public NodeBuilder zipTo(Node target) {
        if (target == null) {
            throw new TalendRuntimeException((ErrorCode)BaseErrorCodes.UNEXPECTED_EXCEPTION, (Throwable)new IllegalArgumentException("Each zipTo() must be followed by nodes()."));
        }
        Node[] sources = this.state.getNodes();
        ZipLink.zip(sources, target);
        this.state = new NodeState(new Node[]{target});
        return this;
    }

    public Node build() {
        return this.sourceNode;
    }

    private static class NodeState
    implements State {
        private final Node[] nodes;

        private NodeState(Node ... nodes) {
            this.nodes = (Node[])Arrays.stream(nodes).map(nextNode -> {
                Node last = nextNode;
                while (last.getLink() != null && last.getLink().getTarget() != null) {
                    last = last.getLink().getTarget();
                }
                return last;
            }).toArray(Node[]::new);
        }

        @Override
        public State next(Function<Node[], Link> link) {
            return new LinkState(this.nodes, link);
        }

        @Override
        public State next(Node ... node) {
            throw new IllegalStateException();
        }

        @Override
        public Node[] getNodes() {
            return this.nodes;
        }
    }

    private static class LinkState
    implements State {
        private final Node[] previousNodes;
        private final Function<Node[], Link> linkFunction;

        private LinkState(Node[] previousNodes, Function<Node[], Link> linkFunction) {
            this.previousNodes = previousNodes;
            this.linkFunction = linkFunction;
        }

        @Override
        public State next(Function<Node[], Link> link) {
            throw new IllegalStateException();
        }

        @Override
        public State next(Node ... nodes) {
            try {
                this.previousNodes[0].setLink(this.linkFunction.apply(nodes));
            }
            catch (UnsupportedOperationException e) {
                throw new TalendRuntimeException((ErrorCode)BaseErrorCodes.UNEXPECTED_EXCEPTION, (Throwable)new Exception("Unable to specify a new output after a terminal node.", e));
            }
            return new NodeState(nodes);
        }

        @Override
        public Node[] getNodes() {
            return this.previousNodes;
        }
    }

    private static interface State {
        public State next(Function<Node[], Link> var1);

        public State next(Node ... var1);

        public Node[] getNodes();
    }
}

