/*
 * Decompiled with CFR 0.152.
 */
package org.talend.dataprep.transformation.pipeline.builder;

import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import org.apache.commons.lang.StringUtils;
import org.talend.dataprep.api.action.ActionDefinition;
import org.talend.dataprep.api.dataset.ColumnMetadata;
import org.talend.dataprep.api.preparation.Action;
import org.talend.dataprep.dataset.StatisticsAdapter;
import org.talend.dataprep.quality.AnalyzerService;
import org.talend.dataprep.transformation.actions.common.ImplicitParameters;
import org.talend.dataprep.transformation.actions.common.RunnableAction;
import org.talend.dataprep.transformation.pipeline.ActionRegistry;
import org.talend.dataprep.transformation.pipeline.Node;
import org.talend.dataprep.transformation.pipeline.builder.ActionsProfile;
import org.talend.dataprep.transformation.pipeline.builder.ActionsStaticProfiler;
import org.talend.dataprep.transformation.pipeline.builder.NodeBuilder;
import org.talend.dataprep.transformation.pipeline.node.BasicNode;
import org.talend.dataprep.transformation.pipeline.node.InvalidDetectionNode;
import org.talend.dataprep.transformation.pipeline.node.StatisticsNode;
import org.talend.dataprep.transformation.pipeline.node.TypeDetectionNode;
import org.talend.dataquality.common.inference.Analyzer;
import org.talend.dataquality.common.inference.Analyzers;

public class StatisticsNodesBuilder {
    private static final Predicate<ColumnMetadata> ALL_COLUMNS = c -> true;
    private AnalyzerService analyzerService;
    private ActionRegistry actionRegistry;
    private StatisticsAdapter statisticsAdapter;
    private List<RunnableAction> actions;
    private List<ColumnMetadata> columns;
    private boolean allowSchemaAnalysis = true;
    private ActionsProfile actionsProfile;
    private Map<Action, ActionDefinition> actionToMetadata;

    private StatisticsNodesBuilder() {
    }

    public static StatisticsNodesBuilder builder() {
        return new StatisticsNodesBuilder();
    }

    public StatisticsNodesBuilder analyzerService(AnalyzerService analyzerService) {
        this.analyzerService = analyzerService;
        return this;
    }

    public StatisticsNodesBuilder actionRegistry(ActionRegistry actionRegistry) {
        this.actionRegistry = actionRegistry;
        return this;
    }

    public StatisticsNodesBuilder statisticsAdapter(StatisticsAdapter statisticsAdapter) {
        this.statisticsAdapter = statisticsAdapter;
        return this;
    }

    public StatisticsNodesBuilder allowSchemaAnalysis(boolean allowSchemaAnalysis) {
        this.allowSchemaAnalysis = allowSchemaAnalysis;
        return this;
    }

    public StatisticsNodesBuilder actions(List<RunnableAction> actions) {
        this.actions = actions;
        return this;
    }

    public StatisticsNodesBuilder columns(List<ColumnMetadata> columns) {
        this.columns = columns;
        return this;
    }

    public Map<Action, ActionDefinition> getActionToMetadata() {
        return this.actionToMetadata;
    }

    public Node buildPreStatistics() {
        if (this.analyzerService == null) {
            return new BasicNode();
        }
        this.performActionsProfiling();
        return this.getTypeDetectionNode(ALL_COLUMNS);
    }

    public Node buildPostStatistics() {
        if (this.analyzerService == null) {
            return new BasicNode();
        }
        this.performActionsProfiling();
        if (this.actionsProfile.needFullAnalysis()) {
            return NodeBuilder.from(this.getTypeDetectionNode(this.actionsProfile.getFilterForFullAnalysis())).to(this.getInvalidDetectionNode(this.actionsProfile.getFilterForInvalidAnalysis())).to(this.getFullStatisticsNode(this.actionsProfile.getFilterForInvalidAnalysis())).build();
        }
        if (this.actionsProfile.needOnlyInvalidAnalysis()) {
            return NodeBuilder.from(this.getInvalidDetectionNode(this.actionsProfile.getFilterForInvalidAnalysis())).to(this.getQualityStatisticsNode(this.actionsProfile.getFilterForInvalidAnalysis())).build();
        }
        return new BasicNode();
    }

    public Node buildIntermediateStatistics(Action nextAction) {
        Node node = null;
        if (this.analyzerService == null) {
            node = new BasicNode();
        } else {
            this.performActionsProfiling();
            if (this.needIntermediateStatistics(nextAction)) {
                Set<ActionDefinition.Behavior> behavior = this.actionToMetadata.get(nextAction).getBehavior();
                node = behavior.contains((Object)ActionDefinition.Behavior.NEED_STATISTICS_PATTERN) ? NodeBuilder.from(this.getTypeDetectionNode(this.actionsProfile.getFilterForFullAnalysis())).to(this.getPatternDetectionNode(this.actionsProfile.getFilterForPatternAnalysis())).build() : NodeBuilder.from(this.getTypeDetectionNode(this.actionsProfile.getFilterForFullAnalysis())).to(this.getInvalidDetectionNode(this.actionsProfile.getFilterForInvalidAnalysis())).build();
            }
        }
        return node;
    }

    private boolean needIntermediateStatistics(Action nextAction) {
        Set<ActionDefinition.Behavior> behavior = this.actionToMetadata.get(nextAction).getBehavior();
        if (behavior.contains((Object)ActionDefinition.Behavior.NEED_STATISTICS_PATTERN) || behavior.contains((Object)ActionDefinition.Behavior.NEED_STATISTICS_INVALID)) {
            return true;
        }
        if (nextAction.getParameters().containsKey(ImplicitParameters.FILTER.getKey())) {
            String filterAsString = nextAction.getParameters().get(ImplicitParameters.FILTER.getKey());
            return StringUtils.contains((String)filterAsString, (String)"valid") || StringUtils.contains((String)filterAsString, (String)"invalid");
        }
        return false;
    }

    private void performActionsProfiling() {
        if (this.actionsProfile != null) {
            return;
        }
        this.checkInputs();
        ActionsStaticProfiler profiler = new ActionsStaticProfiler(this.actionRegistry);
        this.actionsProfile = profiler.profile(this.columns, this.actions);
        this.actionToMetadata = this.actionsProfile.getMetadataByAction();
    }

    private void checkInputs() {
        if (this.actionRegistry == null) {
            throw new MissingResourceException("You need to provide an actionRegistry", "ActionRegistry", null);
        }
        if (this.statisticsAdapter == null) {
            throw new MissingResourceException("You need to provide an statistics adapter", "StatisticsAdapter", null);
        }
        if (this.actions == null) {
            throw new MissingResourceException("You need to provide the whole list of actions", "List", null);
        }
        if (this.columns == null) {
            throw new MissingResourceException("You need to provide the whole list of columns", "List", null);
        }
    }

    private Function<List<ColumnMetadata>, Analyzer<Analyzers.Result>> getQualityAnalyzer() {
        return c -> this.analyzerService.build((List<ColumnMetadata>)c, AnalyzerService.Analysis.QUALITY);
    }

    private Function<List<ColumnMetadata>, Analyzer<Analyzers.Result>> getFullAnalyzer() {
        return StatisticsNode.getDefaultAnalyzer(this.analyzerService);
    }

    private Node getTypeDetectionNode(Predicate<ColumnMetadata> columnFilter) {
        return this.allowSchemaAnalysis ? new TypeDetectionNode(columnFilter, this.statisticsAdapter, this.analyzerService::schemaAnalysis) : new BasicNode();
    }

    private Node getPatternDetectionNode(Predicate<ColumnMetadata> columnFilter) {
        return this.allowSchemaAnalysis ? new TypeDetectionNode(columnFilter, this.statisticsAdapter, c -> this.analyzerService.build((List<ColumnMetadata>)c, AnalyzerService.Analysis.PATTERNS)) : new BasicNode();
    }

    private Node getInvalidDetectionNode(Predicate<ColumnMetadata> columnFilter) {
        return new InvalidDetectionNode(columnFilter);
    }

    private Node getQualityStatisticsNode(Predicate<ColumnMetadata> columnFilter) {
        return new StatisticsNode(this.getQualityAnalyzer(), columnFilter, this.statisticsAdapter);
    }

    private Node getFullStatisticsNode(Predicate<ColumnMetadata> columnFilter) {
        return new StatisticsNode(this.getFullAnalyzer(), columnFilter, this.statisticsAdapter);
    }
}

