/*
 * Decompiled with CFR 0.152.
 */
package org.talend.dataprep.transformation.pipeline.link;

import java.util.Arrays;
import org.talend.dataprep.api.dataset.RowMetadata;
import org.talend.dataprep.api.dataset.row.DataSetRow;
import org.talend.dataprep.transformation.pipeline.Link;
import org.talend.dataprep.transformation.pipeline.Node;
import org.talend.dataprep.transformation.pipeline.RuntimeLink;
import org.talend.dataprep.transformation.pipeline.Signal;
import org.talend.dataprep.transformation.pipeline.Visitor;

public class CloneLink
implements Link,
RuntimeLink {
    private final Node[] nodes;
    private RowMetadata[] clonedMetadata;
    private RowMetadata[][] multiClonedMetadata;

    public CloneLink(Node ... nodes) {
        this.nodes = nodes;
    }

    @Override
    public void emit(DataSetRow row, RowMetadata metadata) {
        this.initClonedMetadata(metadata);
        for (int i = 0; i < this.nodes.length; ++i) {
            this.nodes[i].exec().receive(row.clone(), this.clonedMetadata[i]);
        }
    }

    @Override
    public void emit(DataSetRow[] rows, RowMetadata[] metadatas) {
        this.initClonedMetadata(metadatas);
        for (int i = 0; i < this.nodes.length; ++i) {
            DataSetRow[] clonedRows = (DataSetRow[])Arrays.stream(rows).map(DataSetRow::clone).toArray(DataSetRow[]::new);
            this.nodes[i].exec().receive(clonedRows, this.multiClonedMetadata[i]);
        }
    }

    @Override
    public void signal(Signal signal) {
        for (Node node : this.nodes) {
            node.exec().signal(signal);
        }
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visitCloneLink(this);
    }

    @Override
    public RuntimeLink exec() {
        return this;
    }

    public Node[] getNodes() {
        return this.nodes;
    }

    private void initClonedMetadata(RowMetadata metadata) {
        if (this.clonedMetadata != null) {
            return;
        }
        this.clonedMetadata = (RowMetadata[])Arrays.stream(this.nodes).map(node -> metadata.clone()).toArray(RowMetadata[]::new);
    }

    private void initClonedMetadata(RowMetadata[] multiMetadata) {
        if (this.multiClonedMetadata != null) {
            return;
        }
        this.multiClonedMetadata = (RowMetadata[][])Arrays.stream(this.nodes).map(node -> (RowMetadata[])Arrays.stream(multiMetadata).map(RowMetadata::clone).toArray(RowMetadata[]::new)).toArray(x$0 -> new RowMetadata[x$0][]);
    }
}

