/*
 * Decompiled with CFR 0.152.
 */
package org.talend.dataprep.transformation.pipeline.node;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.talend.dataprep.transformation.api.action.context.TransformationContext;
import org.talend.dataprep.transformation.pipeline.Node;
import org.talend.dataprep.transformation.pipeline.Signal;
import org.talend.dataprep.transformation.pipeline.node.BasicNode;

public class CleanUpNode
extends BasicNode {
    private static final Logger LOGGER = LoggerFactory.getLogger(CleanUpNode.class);
    private final TransformationContext context;

    public CleanUpNode(TransformationContext context) {
        this.context = context;
    }

    @Override
    public void signal(Signal signal) {
        if (signal == Signal.END_OF_STREAM || signal == Signal.CANCEL || signal == Signal.STOP) {
            try {
                this.context.cleanup();
            }
            catch (Exception e) {
                LOGGER.error("Unable to clean context at {}.", (Object)signal, (Object)e);
            }
        }
        super.signal(signal);
    }

    @Override
    public Node copyShallow() {
        return new CleanUpNode(this.context);
    }
}

