/*
 * Decompiled with CFR 0.152.
 */
package org.talend.dataprep.transformation.pipeline.node;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.talend.dataprep.api.dataset.ColumnMetadata;
import org.talend.dataprep.api.dataset.RowMetadata;
import org.talend.dataprep.api.dataset.row.DataSetRow;
import org.talend.dataprep.api.type.Type;
import org.talend.dataprep.transformation.pipeline.node.BasicNode;

abstract class ColumnFilteredNode
extends BasicNode {
    RowMetadata rowMetadata;
    List<ColumnMetadata> filteredColumns;
    Set<String> filteredColumnNames;
    protected final Predicate<? super ColumnMetadata> filter;

    ColumnFilteredNode(Predicate<? super ColumnMetadata> filter) {
        this.filter = filter;
    }

    void performColumnFilter(DataSetRow row, RowMetadata metadata) {
        boolean needRefresh = this.rowMetadata == null || !metadata.equals(this.rowMetadata);
        List<ColumnMetadata> columns = metadata.getColumns();
        if (!columns.isEmpty()) {
            if (this.filteredColumns == null || needRefresh) {
                this.filteredColumns = columns.stream().filter(this.filter).collect(Collectors.toList());
                this.filteredColumnNames = this.filteredColumns.stream().map(ColumnMetadata::getId).collect(Collectors.toSet());
            }
        } else {
            ColumnMetadata.Builder builder = ColumnMetadata.Builder.column().type(Type.STRING);
            int rowSize = row.toArray(DataSetRow.SKIP_TDP_ID).length;
            columns = new ArrayList<ColumnMetadata>(rowSize + 1);
            for (int i = 0; i < rowSize; ++i) {
                ColumnMetadata newColumn = builder.build();
                metadata.addColumn(newColumn);
                columns.add(newColumn);
            }
            this.filteredColumns = columns;
            this.filteredColumnNames = columns.stream().map(ColumnMetadata::getId).collect(Collectors.toSet());
        }
        this.rowMetadata = metadata;
    }
}

