/*
 * Decompiled with CFR 0.152.
 */
package org.talend.dataprep.transformation.pipeline.node;

import org.talend.dataprep.api.dataset.RowMetadata;
import org.talend.dataprep.api.dataset.row.DataSetRow;
import org.talend.dataprep.transformation.actions.common.RunnableAction;
import org.talend.dataprep.transformation.api.action.context.ActionContext;
import org.talend.dataprep.transformation.pipeline.Node;
import org.talend.dataprep.transformation.pipeline.Visitor;
import org.talend.dataprep.transformation.pipeline.node.BasicNode;

public class CompileNode
extends BasicNode {
    private final RunnableAction action;
    private final ActionContext actionContext;
    private int hashCode = 0;

    public CompileNode(RunnableAction action, ActionContext actionContext) {
        this.action = action;
        this.actionContext = actionContext;
    }

    @Override
    public void receive(DataSetRow row, RowMetadata metadata) {
        boolean needCompile;
        boolean bl = needCompile = this.actionContext.getActionStatus() == ActionContext.ActionStatus.NOT_EXECUTED;
        if (this.actionContext.getRowMetadata() == null || this.hashCode != metadata.hashCode()) {
            this.actionContext.setRowMetadata(metadata.clone());
            this.hashCode = metadata.hashCode();
            needCompile = true;
        }
        if (needCompile) {
            this.action.getRowAction().compile(this.actionContext);
        }
        row.setRowMetadata(this.actionContext.getRowMetadata());
        this.link.exec().emit(row, this.actionContext.getRowMetadata());
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visitCompile(this);
    }

    @Override
    public Node copyShallow() {
        return new CompileNode(this.action, this.actionContext);
    }

    public RunnableAction getAction() {
        return this.action;
    }

    public ActionContext getActionContext() {
        return this.actionContext;
    }
}

