/*
 * Decompiled with CFR 0.152.
 */
package org.talend.dataprep.transformation.pipeline.node;

import java.util.function.BiPredicate;
import org.talend.dataprep.api.dataset.RowMetadata;
import org.talend.dataprep.api.dataset.row.DataSetRow;
import org.talend.dataprep.transformation.pipeline.Node;
import org.talend.dataprep.transformation.pipeline.node.BasicNode;

public class FilterNode
extends BasicNode {
    private final BiPredicate<DataSetRow, RowMetadata>[] filters;

    @SafeVarargs
    public FilterNode(BiPredicate<DataSetRow, RowMetadata> ... filters) {
        this.filters = filters;
    }

    @Override
    public void receive(DataSetRow row, RowMetadata metadata) {
        if (this.filters != null && this.filters[0].test(row, metadata)) {
            super.receive(row, metadata);
        }
    }

    @Override
    public void receive(DataSetRow[] rows, RowMetadata[] metadatas) {
        if (this.test(rows, metadatas)) {
            super.receive(rows, metadatas);
        }
    }

    private boolean test(DataSetRow[] rows, RowMetadata[] metadatas) {
        if (this.filters == null) {
            return true;
        }
        for (int i = 0; i < rows.length && i < this.filters.length; ++i) {
            if (this.filters[i].test(rows[i], metadatas[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    public Node copyShallow() {
        return new FilterNode(this.filters);
    }
}

