/*
 * Decompiled with CFR 0.152.
 */
package org.talend.dataprep.transformation.pipeline.node;

import java.util.function.Predicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.talend.dataprep.api.dataset.ColumnMetadata;
import org.talend.dataprep.api.dataset.RowMetadata;
import org.talend.dataprep.api.dataset.row.DataSetRow;
import org.talend.dataprep.api.dataset.row.InvalidMarker;
import org.talend.dataprep.quality.AnalyzerService;
import org.talend.dataprep.transformation.actions.Providers;
import org.talend.dataprep.transformation.pipeline.Monitored;
import org.talend.dataprep.transformation.pipeline.Node;
import org.talend.dataprep.transformation.pipeline.Signal;
import org.talend.dataprep.transformation.pipeline.Visitor;
import org.talend.dataprep.transformation.pipeline.node.ColumnFilteredNode;
import org.talend.dataquality.common.inference.Analyzer;
import org.talend.dataquality.common.inference.Analyzers;

public class InvalidDetectionNode
extends ColumnFilteredNode
implements Monitored {
    private static final Logger LOGGER = LoggerFactory.getLogger(InvalidDetectionNode.class);
    private long totalTime;
    private long count;
    private transient InvalidMarker invalidMarker;
    private transient Analyzer<Analyzers.Result> configuredAnalyzer;
    private transient AnalyzerService analyzerService;

    public InvalidDetectionNode(Predicate<? super ColumnMetadata> filter) {
        super(filter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void receive(DataSetRow row, RowMetadata metadata) {
        long start = System.currentTimeMillis();
        try {
            this.performColumnFilter(row, metadata);
            if (this.configuredAnalyzer == null) {
                this.configuredAnalyzer = this.getAnalyzerService().build(this.filteredColumns, AnalyzerService.Analysis.QUALITY);
                this.invalidMarker = new InvalidMarker(this.filteredColumns, this.configuredAnalyzer);
            }
            super.receive(this.invalidMarker.apply(row), metadata);
        }
        finally {
            this.totalTime += System.currentTimeMillis() - start;
            ++this.count;
        }
    }

    private AnalyzerService getAnalyzerService() {
        if (this.analyzerService == null) {
            this.analyzerService = Providers.get(AnalyzerService.class);
        }
        return this.analyzerService;
    }

    @Override
    public void signal(Signal signal) {
        try {
            if (this.configuredAnalyzer != null) {
                this.configuredAnalyzer.close();
            }
        }
        catch (Exception e) {
            LOGGER.error("Unable to close analyzer.", (Throwable)e);
        }
        super.signal(signal);
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visitNode(this);
    }

    @Override
    public Node copyShallow() {
        return new InvalidDetectionNode(this.filter);
    }

    @Override
    public long getTotalTime() {
        return this.totalTime;
    }

    @Override
    public long getCount() {
        return this.count;
    }
}

