/*
 * Decompiled with CFR 0.152.
 */
package org.talend.dataprep.transformation.pipeline.node;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.talend.dataprep.api.dataset.RowMetadata;
import org.talend.dataprep.api.dataset.row.DataSetRow;
import org.talend.dataprep.transformation.pipeline.Node;
import org.talend.dataprep.transformation.pipeline.node.BasicNode;

public class LimitNode
extends BasicNode {
    private static final Logger LOGGER = LoggerFactory.getLogger(LimitNode.class);
    private int count = 0;
    private final long limit;
    private final Runnable callback;

    public LimitNode(long limit) {
        this(limit, null);
        LOGGER.trace("Limit set to {}", (Object)limit);
    }

    public LimitNode(long limit, Runnable callback) {
        this.limit = limit;
        this.callback = callback;
    }

    @Override
    public void receive(DataSetRow row, RowMetadata metadata) {
        if ((long)this.count >= this.limit) {
            return;
        }
        super.receive(row, metadata);
        this.increment();
    }

    @Override
    public void receive(DataSetRow[] rows, RowMetadata[] metadatas) {
        if ((long)this.count >= this.limit) {
            return;
        }
        super.receive(rows, metadatas);
        this.increment();
    }

    private void increment() {
        if ((long)(++this.count) == this.limit && this.callback != null) {
            LOGGER.debug("limit {} reached", (Object)this.limit);
            this.callback.run();
        }
    }

    @Override
    public Node copyShallow() {
        return new LimitNode(this.limit, this.callback);
    }
}

