/*
 * Decompiled with CFR 0.152.
 */
package org.talend.dataprep.transformation.pipeline.node;

import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.talend.dataprep.api.dataset.ColumnMetadata;
import org.talend.dataprep.api.dataset.RowMetadata;
import org.talend.dataprep.api.dataset.row.DataSetRow;
import org.talend.dataprep.dataset.StatisticsAdapter;
import org.talend.dataprep.quality.AnalyzerService;
import org.talend.dataprep.transformation.pipeline.Node;
import org.talend.dataprep.transformation.pipeline.Signal;
import org.talend.dataprep.transformation.pipeline.node.ColumnFilteredNode;
import org.talend.dataquality.common.inference.Analyzer;
import org.talend.dataquality.common.inference.Analyzers;

public class StatisticsNode
extends ColumnFilteredNode {
    private static final Logger LOGGER = LoggerFactory.getLogger(StatisticsNode.class);
    private final Function<List<ColumnMetadata>, Analyzer<Analyzers.Result>> analyzer;
    private final StatisticsAdapter adapter;
    private Analyzer<Analyzers.Result> configuredAnalyzer;

    public StatisticsNode(Function<List<ColumnMetadata>, Analyzer<Analyzers.Result>> analyzer, Predicate<? super ColumnMetadata> filter, StatisticsAdapter adapter) {
        super(filter);
        this.analyzer = analyzer;
        this.adapter = adapter;
    }

    public StatisticsNode(AnalyzerService analyzerService, Predicate<ColumnMetadata> filter, StatisticsAdapter adapter) {
        this(StatisticsNode.getDefaultAnalyzer(analyzerService), filter, adapter);
    }

    public static Function<List<ColumnMetadata>, Analyzer<Analyzers.Result>> getDefaultAnalyzer(AnalyzerService analyzerService) {
        return c -> analyzerService.build((List<ColumnMetadata>)c, AnalyzerService.Analysis.QUALITY, AnalyzerService.Analysis.CARDINALITY, AnalyzerService.Analysis.FREQUENCY, AnalyzerService.Analysis.PATTERNS, AnalyzerService.Analysis.LENGTH, AnalyzerService.Analysis.QUANTILES, AnalyzerService.Analysis.SUMMARY, AnalyzerService.Analysis.HISTOGRAM);
    }

    @Override
    public void receive(DataSetRow row, RowMetadata metadata) {
        this.performColumnFilter(row, metadata);
        if (this.configuredAnalyzer == null) {
            this.configuredAnalyzer = this.analyzer.apply(this.filteredColumns);
        }
        if (!row.isDeleted()) {
            this.configuredAnalyzer.analyze(row.filter(this.filteredColumns).order(this.filteredColumns).toArray(DataSetRow.SKIP_TDP_ID));
        }
        super.receive(row, metadata);
    }

    @Override
    public void signal(Signal signal) {
        if (signal == Signal.END_OF_STREAM || signal == Signal.CANCEL || signal == Signal.STOP) {
            if (this.configuredAnalyzer != null) {
                this.adapter.adapt(this.filteredColumns, this.configuredAnalyzer.getResult());
            } else {
                LOGGER.warn("No data received.");
            }
        }
        super.signal(signal);
    }

    @Override
    public Node copyShallow() {
        return new StatisticsNode(this.analyzer, this.filter, this.adapter);
    }
}

