/*
 * Decompiled with CFR 0.152.
 */
package org.talend.dataprep.transformation.pipeline.node;

import org.talend.dataprep.api.dataset.RowMetadata;
import org.talend.dataprep.api.dataset.row.DataSetRow;
import org.talend.dataprep.api.preparation.Step;
import org.talend.dataprep.transformation.pipeline.Link;
import org.talend.dataprep.transformation.pipeline.Node;
import org.talend.dataprep.transformation.pipeline.RuntimeLink;
import org.talend.dataprep.transformation.pipeline.Signal;
import org.talend.dataprep.transformation.pipeline.Visitor;
import org.talend.dataprep.transformation.pipeline.node.BasicNode;

public class StepNode
extends BasicNode {
    private final Step step;
    private final Node entryNode;
    private final Node lastNode;
    private RowMetadata lastRowMetadata;
    private RowMetadata previousStepRowMetadata;

    public StepNode(Step step, RowMetadata previousStepRowMetadata, Node entryNode, Node lastNode) {
        this.step = step;
        this.previousStepRowMetadata = previousStepRowMetadata;
        this.entryNode = entryNode;
        this.lastNode = lastNode;
    }

    public Node getEntryNode() {
        return this.entryNode;
    }

    public Step getStep() {
        return this.step;
    }

    @Override
    public void receive(DataSetRow row, RowMetadata metadata) {
        RowMetadata processingRowMetadata = metadata;
        if (this.previousStepRowMetadata != null) {
            processingRowMetadata = this.previousStepRowMetadata;
        }
        if (this.lastNode.getLink() == null) {
            RuntimeLink stepLink = this.getLink().exec();
            this.lastNode.setLink(new StepLink(stepLink));
        }
        this.lastRowMetadata = processingRowMetadata;
        this.entryNode.exec().receive(row, processingRowMetadata);
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visitStepNode(this);
    }

    @Override
    public Node copyShallow() {
        return new StepNode(this.step, this.previousStepRowMetadata, this.entryNode, this.lastNode);
    }

    public RowMetadata getRowMetadata() {
        return this.lastRowMetadata;
    }

    private static class StepLink
    implements Link {
        private final RuntimeLink stepLink;

        private StepLink(RuntimeLink stepLink) {
            this.stepLink = stepLink;
        }

        @Override
        public void accept(Visitor visitor) {
        }

        @Override
        public RuntimeLink exec() {
            return new RuntimeLink(){

                @Override
                public void emit(DataSetRow row, RowMetadata metadata) {
                    stepLink.emit(row, metadata);
                }

                @Override
                public void emit(DataSetRow[] rows, RowMetadata[] metadatas) {
                    stepLink.emit(rows, metadatas);
                }

                @Override
                public void signal(Signal signal) {
                    stepLink.signal(signal);
                }
            };
        }
    }
}

