/*
 * Decompiled with CFR 0.152.
 */
package org.talend.dataprep.transformation.pipeline.node;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.talend.daikon.exception.TalendRuntimeException;
import org.talend.daikon.exception.error.ErrorCode;
import org.talend.dataprep.BaseErrorCodes;
import org.talend.dataprep.api.dataset.ColumnMetadata;
import org.talend.dataprep.api.dataset.DataSet;
import org.talend.dataprep.api.dataset.RowMetadata;
import org.talend.dataprep.api.dataset.row.DataSetRow;
import org.talend.dataprep.dataset.StatisticsAdapter;
import org.talend.dataprep.transformation.pipeline.Monitored;
import org.talend.dataprep.transformation.pipeline.Node;
import org.talend.dataprep.transformation.pipeline.Signal;
import org.talend.dataprep.transformation.pipeline.Visitor;
import org.talend.dataprep.transformation.pipeline.node.ColumnFilteredNode;
import org.talend.dataprep.util.FilesHelper;
import org.talend.dataquality.common.inference.Analyzer;
import org.talend.dataquality.common.inference.Analyzers;

public class TypeDetectionNode
extends ColumnFilteredNode
implements Monitored {
    private static final Logger LOGGER = LoggerFactory.getLogger(TypeDetectionNode.class);
    private final JsonGenerator generator;
    private final File reservoir;
    private final Function<List<ColumnMetadata>, Analyzer<Analyzers.Result>> analyzer;
    private final StatisticsAdapter adapter;
    private long totalTime;
    private Analyzer<Analyzers.Result> resultAnalyzer;
    private long count;

    public TypeDetectionNode(Predicate<? super ColumnMetadata> filter, StatisticsAdapter adapter, Function<List<ColumnMetadata>, Analyzer<Analyzers.Result>> analyzer) {
        super(filter);
        this.analyzer = analyzer;
        this.adapter = adapter;
        try {
            this.reservoir = File.createTempFile("TypeDetection", ".zip");
            JsonFactory factory = new JsonFactory();
            this.generator = factory.createGenerator((OutputStream)new GZIPOutputStream((OutputStream)new FileOutputStream(this.reservoir), true));
            this.generator.writeStartObject();
            this.generator.writeFieldName("records");
            this.generator.writeStartArray();
        }
        catch (IOException e) {
            throw new TalendRuntimeException((ErrorCode)BaseErrorCodes.UNEXPECTED_EXCEPTION, (Throwable)e);
        }
    }

    @Override
    public void receive(DataSetRow row, RowMetadata metadata) {
        this.performColumnFilter(row, metadata);
        this.store(row, metadata.getColumns());
        this.analyze(row);
        ++this.count;
    }

    private void store(DataSetRow row, List<ColumnMetadata> columns) {
        try {
            Optional<Long> tdpId;
            this.generator.writeStartObject();
            columns.forEach(column -> {
                try {
                    this.generator.writeStringField(column.getId(), row.get(column.getId()));
                }
                catch (IOException e) {
                    throw new TalendRuntimeException((ErrorCode)BaseErrorCodes.UNEXPECTED_EXCEPTION, (Throwable)e);
                }
            });
            if (row.isDeleted()) {
                this.generator.writeBooleanField("_deleted", true);
            }
            if ((tdpId = Optional.ofNullable(row.getTdpId())).isPresent()) {
                this.generator.writeNumberField("tdpId", tdpId.get().longValue());
            }
            for (Map.Entry<String, String> entry : row.getInternalValues().entrySet()) {
                this.generator.writeStringField(entry.getKey(), entry.getValue());
            }
            this.generator.writeEndObject();
        }
        catch (IOException e) {
            throw new TalendRuntimeException((ErrorCode)BaseErrorCodes.UNEXPECTED_EXCEPTION, (Throwable)e);
        }
    }

    private void analyze(DataSetRow row) {
        if (!row.isDeleted()) {
            if (this.resultAnalyzer == null) {
                this.resultAnalyzer = this.analyzer.apply(this.filteredColumns);
            }
            Object[] values = row.filter(this.filteredColumns).order(this.rowMetadata.getColumns()).toArray(DataSetRow.SKIP_TDP_ID.and(e -> this.filteredColumnNames.contains(e.getKey())));
            try {
                this.resultAnalyzer.analyze((String[])values);
            }
            catch (Exception e2) {
                LOGGER.debug("Unable to analyze row '{}'.", (Object)Arrays.toString(values), (Object)e2);
            }
        }
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visitNode(this);
    }

    @Override
    public Node copyShallow() {
        return new TypeDetectionNode(this.filter, this.adapter, this.analyzer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void signal(Signal signal) {
        block24: {
            long start = System.currentTimeMillis();
            try {
                if (signal != Signal.END_OF_STREAM && signal != Signal.CANCEL && signal != Signal.STOP) break block24;
                this.generator.writeEndArray();
                this.generator.writeEndObject();
                this.generator.flush();
                this.generator.close();
                ObjectMapper mapper = new ObjectMapper();
                if (this.rowMetadata != null && this.resultAnalyzer != null) {
                    this.resultAnalyzer.end();
                    List<ColumnMetadata> columns = this.rowMetadata.getColumns();
                    this.adapter.adapt(columns, this.resultAnalyzer.getResult(), this.filter);
                    this.resultAnalyzer.close();
                }
                try (JsonParser parser = mapper.getFactory().createParser((Reader)new InputStreamReader((InputStream)new GZIPInputStream(new FileInputStream(this.reservoir)), StandardCharsets.UTF_8));){
                    DataSet dataSet = (DataSet)mapper.reader(DataSet.class).readValue(parser);
                    dataSet.getRecords().forEach(r -> {
                        r.setRowMetadata(this.rowMetadata);
                        this.link.exec().emit((DataSetRow)r, this.rowMetadata);
                    });
                }
            }
            catch (Exception e) {
                LOGGER.warn("Unable to perform delayed analysis.", (Throwable)e);
            }
            finally {
                try {
                    this.generator.close();
                }
                catch (IOException e) {
                    LOGGER.error("Unable to close JSON generator (causing potential temp file delete issues).", (Throwable)e);
                }
                FilesHelper.deleteQuietly(this.reservoir);
                this.totalTime += System.currentTimeMillis() - start;
            }
        }
        super.signal(signal);
    }

    @Override
    public long getTotalTime() {
        return this.totalTime;
    }

    @Override
    public long getCount() {
        return this.count;
    }
}

