/*
 * Decompiled with CFR 0.152.
 */
package org.talend.dataprep.transformation.pipeline.node;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Deque;
import java.util.List;
import java.util.stream.IntStream;
import org.talend.dataprep.api.dataset.RowMetadata;
import org.talend.dataprep.api.dataset.row.DataSetRow;
import org.talend.dataprep.transformation.pipeline.Node;
import org.talend.dataprep.transformation.pipeline.Signal;
import org.talend.dataprep.transformation.pipeline.link.BasicLink;

public class ZipLink
extends BasicLink {
    private final int numberOfSource;
    private final Stack[] stacks;
    private final List<Signal> signalStack;

    private ZipLink(Node[] sources, Node target) {
        super(target);
        this.numberOfSource = sources.length;
        this.signalStack = new ArrayList<Signal>(this.numberOfSource);
        this.stacks = (Stack[])IntStream.range(0, this.numberOfSource).mapToObj(n -> new Stack()).toArray(Stack[]::new);
        IntStream.range(0, this.numberOfSource).forEach(index -> {
            Node source = sources[index];
            Zipper zipper = new Zipper(this, target, index);
            source.setLink(zipper);
        });
    }

    @Override
    public void signal(Signal signal) {
        this.signalStack.add(signal);
        if (this.signalStack.size() == this.numberOfSource) {
            super.signal(signal);
            this.signalStack.clear();
        }
    }

    private void emit(DataSetRow row, RowMetadata metadata, int index) {
        this.stacks[index].push(row.clone(), metadata);
        if (this.allStacksHaveNext()) {
            DataSetRow[] rows = this.popAllStacksNextRow();
            RowMetadata[] metadatas = this.popAllStacksNextMetadata();
            super.emit(rows, metadatas);
        }
    }

    public static ZipLink zip(Node[] sources, Node target) {
        return new ZipLink(sources, target);
    }

    private RowMetadata[] popAllStacksNextMetadata() {
        return (RowMetadata[])Arrays.stream(this.stacks).map(Stack::popMetadata).toArray(RowMetadata[]::new);
    }

    private DataSetRow[] popAllStacksNextRow() {
        return (DataSetRow[])Arrays.stream(this.stacks).map(Stack::popRow).toArray(DataSetRow[]::new);
    }

    private boolean allStacksHaveNext() {
        return Arrays.stream(this.stacks).allMatch(Stack::hasNext);
    }

    private class Stack {
        private final Deque<DataSetRow> rowStack = new ArrayDeque<DataSetRow>();
        private final Deque<RowMetadata> metadataStack = new ArrayDeque<RowMetadata>();

        private Stack() {
        }

        public boolean hasNext() {
            return !this.rowStack.isEmpty();
        }

        void push(DataSetRow row, RowMetadata metadata) {
            this.rowStack.addFirst(row);
            this.metadataStack.addFirst(metadata);
        }

        DataSetRow popRow() {
            return this.rowStack.pollLast();
        }

        RowMetadata popMetadata() {
            return this.metadataStack.pollLast();
        }
    }

    public class Zipper
    extends BasicLink {
        private final ZipLink proxy;
        private final int index;

        Zipper(ZipLink proxy, Node target, int index) {
            super(target);
            this.proxy = proxy;
            this.index = index;
        }

        @Override
        public void emit(DataSetRow row, RowMetadata metadata) {
            this.proxy.emit(row, metadata, this.index);
        }

        @Override
        public void signal(Signal signal) {
            this.proxy.signal(signal);
        }
    }
}

