/*
 * Decompiled with CFR 0.152.
 */
package org.talend.dataprep.util;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FilesHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(FilesHelper.class);

    private FilesHelper() {
    }

    public static void deleteQuietly(File file) {
        try {
            FilesHelper.delete(file);
        }
        catch (Exception e) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Unable to delete file {}.", (Object)file, (Object)e);
            }
            LOGGER.warn("Unable to delete file {}.", (Object)file);
        }
    }

    public static void delete(File file) throws IOException {
        if (file == null) {
            return;
        }
        if (file.getName().startsWith(".nfs")) {
            return;
        }
        if (file.exists() && !file.delete()) {
            Path path = FileSystems.getDefault().getPath(file.getAbsolutePath(), new String[0]);
            try {
                LOGGER.debug("Unable to delete file {} using IO, using NIO for more detailed error.", (Object)file);
                Files.delete(path);
            }
            catch (IOException e) {
                LOGGER.debug("Unable to delete file {} using NIO, forcing GC.", (Object)file, (Object)e);
                System.gc();
                Files.delete(path);
            }
        }
    }
}

